/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import io.endertech.config.ItemConfig;
import io.endertech.item.ItemExchanger;
import io.endertech.util.BlockCoord;
import io.endertech.util.Exchange;
import io.endertech.util.Geometry;
import io.endertech.util.inventory.InventoryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldEventHandler {
    public static Map<Integer, Set<Exchange>> exchanges = new HashMap<Integer, Set<Exchange>>();

    public static void queueExchangeRequest(World world, BlockCoord origin, int radius, Block source, int sourceMeta, ItemStack target, EntityPlayer player, int hotbar_id, ForgeDirection orientation) {
        if (target.func_77969_a(new ItemStack(source, 1, sourceMeta))) {
            return;
        }
        int dimensionId = world.field_73011_w.field_76574_g;
        Set<Object> queue = (LinkedHashSet)exchanges.get(dimensionId);
        if (queue == null) {
            exchanges.put(dimensionId, new LinkedHashSet());
            queue = exchanges.get(dimensionId);
        }
        queue.add(new Exchange(origin, radius, source, sourceMeta, target, player, hotbar_id, orientation));
        world.func_72956_a((Entity)player, "mob.endermen.portal", 1.0f, 1.0f);
        exchanges.put(dimensionId, queue);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        this.exchangeTick(event.world);
    }

    private void exchangeTick(World world) {
        int dimensionId = world.field_73011_w.field_76574_g;
        Set<Exchange> queue = exchanges.get(dimensionId);
        if (queue == null || queue.size() == 0) {
            return;
        }
        this.checkAndPerformExchanges(queue, world);
    }

    private void checkAndPerformExchanges(Set<Exchange> queue, World world) {
        HashSet<Exchange> removals = new HashSet<Exchange>();
        for (Exchange exchange : queue) {
            ItemStack exchangerStack = exchange.player.field_71071_by.func_70301_a(exchange.hotbar_id);
            boolean cullExchange = false;
            if (exchangerStack == null || exchangerStack.func_77973_b() == null || !(exchangerStack.func_77973_b() instanceof ItemExchanger)) {
                cullExchange = true;
            }
            if (cullExchange) {
                removals.add(exchange);
                continue;
            }
            ItemExchanger exchanger = (ItemExchanger)exchangerStack.func_77973_b();
            --exchange.currentRadiusTicks;
            if (exchange.currentRadiusTicks > 0) continue;
            Set<BlockCoord> blocks = Geometry.squareSet(exchange.currentRadius - 1, exchange.origin, exchange.orientation);
            boolean stop = false;
            for (BlockCoord blockCoord : blocks) {
                if (stop) break;
                ExchangeResult result = this.checkAndPerformExchange(exchange, exchanger, exchangerStack, world, new BlockCoord(blockCoord.x, blockCoord.y, blockCoord.z));
                switch (result) {
                    case FAIL_ENERGY: 
                    case FAIL_NO_SOURCE_BLOCKS: 
                    case FAIL_INVENTORY_SPACE: {
                        stop = true;
                        removals.add(exchange);
                    }
                }
            }
            ++exchange.currentRadius;
            if (exchange.currentRadius > exchange.radius) {
                removals.add(exchange);
                continue;
            }
            exchange.currentRadiusTicks = 10;
        }
        for (Exchange removal : removals) {
            queue.remove(removal);
        }
    }

    private int calculateExchangeCost(Exchange exchange, Block worldBlock, World world, BlockCoord blockCoord) {
        int hardnessCost;
        int exchangeCost;
        int baseCost = ItemConfig.itemExchangerBaseCost;
        int radiusCost = ItemConfig.itemExchangerRadiusCost;
        double blockHardness = worldBlock.func_149712_f(world, blockCoord.x, blockCoord.y, blockCoord.z);
        if (blockHardness < 1.0) {
            blockHardness = 1.0;
        }
        if (blockHardness > 50.0) {
            blockHardness = 50.0;
        }
        if ((exchangeCost = baseCost + radiusCost * exchange.currentRadius + (hardnessCost = (int)blockHardness * ItemConfig.itemExchangerHardnessCost)) < ItemConfig.itemExchangerMinimumCost) {
            exchangeCost = ItemConfig.itemExchangerMinimumCost;
        }
        if (exchangeCost > ItemConfig.itemExchangerMaximumCost) {
            exchangeCost = ItemConfig.itemExchangerMaximumCost;
        }
        return exchangeCost;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExchangeResult checkAndPerformExchange(Exchange exchange, ItemExchanger exchanger, ItemStack exchangerStack, World world, BlockCoord blockCoord) {
        Block block = world.func_147439_a(blockCoord.x, blockCoord.y, blockCoord.z);
        if (!Exchange.blockSuitableForExchange(blockCoord, world, exchange.source, exchange.sourceMeta, exchange.target, exchangerStack, exchange.currentRadius - 1)) {
            return ExchangeResult.FAIL_BLOCK_NOT_REPLACEABLE;
        }
        int exchangeCost = this.calculateExchangeCost(exchange, block, world, blockCoord);
        if (exchanger.extractEnergy(exchange.player.field_71071_by.func_70301_a(exchange.hotbar_id), exchangeCost, true) < exchangeCost) {
            return ExchangeResult.FAIL_ENERGY;
        }
        int sourceSlot = InventoryHelper.findFirstItemStack((IInventory)exchange.player.field_71071_by, exchange.target);
        if (sourceSlot < 0) {
            if (!ItemExchanger.isCreative(exchangerStack)) {
                return ExchangeResult.FAIL_NO_SOURCE_BLOCKS;
            }
        }
        if (!ItemExchanger.isCreative(exchangerStack)) {
            ArrayList droppedItems = block.getDrops(exchange.player.field_70170_p, blockCoord.x, blockCoord.y, blockCoord.z, exchange.sourceMeta, 0);
            boolean didPutItemsInInventory = InventoryHelper.checkAndPutItemStacksInToInventory((IInventory)exchange.player.field_71071_by, (ArrayList<ItemStack>)droppedItems);
            if (!didPutItemsInInventory) return ExchangeResult.FAIL_INVENTORY_SPACE;
            InventoryHelper.consumeItem((IInventory)exchange.player.field_71071_by, sourceSlot);
            this.performExchange(exchange, blockCoord, exchanger, world, exchangeCost);
            return ExchangeResult.SUCCESS;
        } else {
            this.performExchange(exchange, blockCoord, exchanger, world, exchangeCost);
        }
        return ExchangeResult.SUCCESS;
    }

    private void performExchange(Exchange exchange, BlockCoord blockCoord, ItemExchanger exchanger, World world, int exchangeCost) {
        world.func_147465_d(blockCoord.x, blockCoord.y, blockCoord.z, Block.func_149634_a((Item)exchange.target.func_77973_b()), exchange.target.func_77960_j(), 3);
        exchanger.extractEnergy(exchange.player.field_71071_by.func_70301_a(exchange.hotbar_id), exchangeCost, false);
        world.func_72926_e(2001, blockCoord.x, blockCoord.y, blockCoord.z, Block.func_149682_b((Block)exchange.source) + (exchange.sourceMeta << 12));
    }

    public static enum ExchangeResult {
        FAIL_ENERGY,
        FAIL_MISMATCH,
        FAIL_NO_SOURCE_BLOCKS,
        FAIL_INVENTORY_SPACE,
        FAIL_BLOCK_NOT_REPLACEABLE,
        FAIL_BLOCK_NOT_EXPOSED,
        SUCCESS;

    }
}

