/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenDecoration
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final WeightedRandomBlock[] onBlock;
    private final int clusterSize;
    public boolean seeSky = true;
    public boolean checkStay = true;
    public int stackHeight = 1;
    public int xVar = 8;
    public int yVar = 4;
    public int zVar = 8;

    public WorldGenDecoration(List<WeightedRandomBlock> blocks, int count, List<WeightedRandomBlock> material, List<WeightedRandomBlock> on) {
        this.cluster = blocks;
        this.clusterSize = count;
        this.genBlock = material == null ? null : material.toArray(new WeightedRandomBlock[material.size()]);
        this.onBlock = on == null ? null : on.toArray(new WeightedRandomBlock[on.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int xStart, int yStart, int zStart) {
        boolean r = false;
        int l = this.clusterSize;
        block0: while (l-- > 0) {
            int stack;
            int z;
            int y;
            int x = xStart + rand.nextInt(this.xVar) - rand.nextInt(this.xVar);
            if (!world.func_72899_e(x, y = yStart + (this.yVar > 1 ? rand.nextInt(this.yVar) - rand.nextInt(this.yVar) : 0), z = zStart + rand.nextInt(this.zVar) - rand.nextInt(this.zVar))) {
                ++l;
                continue;
            }
            if (this.seeSky && !world.func_72937_j(x, y, z) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y - 1, z, this.onBlock) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.genBlock)) continue;
            WeightedRandomBlock block = WorldGenMinableCluster.selectBlock(world, this.cluster);
            int n = stack = this.stackHeight > 1 ? rand.nextInt(this.stackHeight) : 0;
            while (!this.checkStay || block.block.func_149718_j(world, x, y, z)) {
                r |= world.func_147465_d(x, y, z, block.block, block.metadata, 2);
                if (WorldGenMinableCluster.canGenerateInBlock(world, x, ++y, z, this.genBlock) && stack-- > 0) continue;
                continue block0;
            }
        }
        return r;
    }
}

