/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.item.IEmpowerableItem;
import cofh.api.item.IInventoryContainerItem;
import cofh.lib.util.OreDictionaryProxy;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class ItemHelper {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";
    public static OreDictionaryProxy oreProxy = new OreDictionaryProxy();

    private ItemHelper() {
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item, stackSize);
        return stack;
    }

    public static ItemStack cloneStack(Block item, int stackSize) {
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item, stackSize);
        return stack;
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack == null) {
            return null;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.field_77994_a = stackSize;
        return retStack;
    }

    public static ItemStack cloneStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack retStack = stack.func_77946_l();
        return retStack;
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (other != null && other.field_77990_d != null) {
            container.field_77990_d = (NBTTagCompound)other.field_77990_d.func_74737_b();
        }
        return container;
    }

    public static NBTTagCompound setItemStackTagName(NBTTagCompound tag, String name) {
        if (name == "") {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_74764_b("display")) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        tag.func_74775_l("display").func_74778_a("Name", name);
        return tag;
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound nbt) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("id")));
        stack.field_77994_a = nbt.func_74762_e("Count");
        stack.func_77964_b(Math.max(0, nbt.func_74765_d("Damage")));
        if (nbt.func_150297_b("tag", 10)) {
            stack.field_77990_d = nbt.func_74775_l("tag");
        }
        return stack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)ItemHelper.getItemDamage(stack));
        if (stack.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
        return nbt;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, int amount, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", amount);
        nbt.func_74777_a("Damage", (short)ItemHelper.getItemDamage(stack));
        if (stack.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
        return nbt;
    }

    public static String getNameFromItemStack(ItemStack stack) {
        if (stack == null || stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("display")) {
            return "";
        }
        return stack.field_77990_d.func_74775_l("display").func_74779_i("Name");
    }

    public static ItemStack consumeItem(ItemStack stack) {
        boolean largerStack;
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.field_77994_a > 1;
        if (largerStack) {
            --stack.field_77994_a;
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret == null) {
                return null;
            }
            if (ret.func_77984_f() && ret.func_77960_j() > ret.func_77958_k()) {
                ret = null;
            }
            return ret;
        }
        return largerStack ? stack : null;
    }

    public static ItemStack consumeItem(ItemStack stack, EntityPlayer player) {
        boolean largerStack;
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.field_77994_a > 1;
        if (largerStack) {
            --stack.field_77994_a;
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret == null || ret.func_77984_f() && ret.func_77960_j() > ret.func_77958_k()) {
                ret = null;
            }
            if (stack.field_77994_a < 1) {
                return ret;
            }
            if (ret != null && !player.field_71071_by.func_70441_a(ret)) {
                player.func_146097_a(ret, false, true);
            }
        }
        if (stack.field_77994_a > 0) {
            return stack;
        }
        return null;
    }

    public static boolean disposePlayerItem(ItemStack stack, ItemStack dropStack, EntityPlayer entityplayer, boolean allowDrop) {
        return ItemHelper.disposePlayerItem(stack, dropStack, entityplayer, allowDrop, true);
    }

    public static boolean disposePlayerItem(ItemStack stack, ItemStack dropStack, EntityPlayer entityplayer, boolean allowDrop, boolean allowReplace) {
        if (entityplayer == null || entityplayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (allowReplace && stack.field_77994_a <= 1) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, dropStack);
            return true;
        }
        if (allowDrop) {
            --stack.field_77994_a;
            if (dropStack != null && !entityplayer.field_71071_by.func_70441_a(dropStack)) {
                entityplayer.func_146097_a(dropStack, false, true);
            }
            return true;
        }
        return false;
    }

    public static int getItemDamage(ItemStack stack) {
        return Items.field_151045_i.getDamage(stack);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[0] == null || dmgItems[0].func_77973_b() == null) {
            return null;
        }
        if (dmgItems[1] != null && dmgItems[0].func_77973_b() == dmgItems[1].func_77973_b() && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && dmgItems[0].func_77973_b().isRepairable()) {
            Item theItem = dmgItems[0].func_77973_b();
            int var13 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int var8 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int var9 = var13 + var8 + theItem.func_77612_l() * 5 / 100;
            int var10 = Math.max(0, theItem.func_77612_l() - var9);
            return new ItemStack(dmgItems[0].func_77973_b(), 1, var10);
        }
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static ItemStack getOre(String oreName) {
        return oreProxy.getOre(oreName);
    }

    public static String getOreName(ItemStack stack) {
        return oreProxy.getOreName(stack);
    }

    public static boolean isOreIDEqual(ItemStack stack, int oreID) {
        return oreProxy.isOreIDEqual(stack, oreID);
    }

    public static boolean isOreNameEqual(ItemStack stack, String oreName) {
        return oreProxy.isOreNameEqual(stack, oreName);
    }

    public static boolean oreNameExists(String oreName) {
        return oreProxy.oreNameExists(oreName);
    }

    public static boolean hasOreName(ItemStack stack) {
        return !ItemHelper.getOreName(stack).equals("Unknown");
    }

    public static boolean isBlock(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(ORE);
    }

    public static boolean isDust(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(INGOT);
    }

    public static boolean isNugget(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(LOG);
    }

    public static final ItemStack stack(Item t) {
        return new ItemStack(t);
    }

    public static final ItemStack stack(Item t, int s) {
        return new ItemStack(t, s);
    }

    public static final ItemStack stack(Item t, int s, int m) {
        return new ItemStack(t, s, m);
    }

    public static final ItemStack stack(Block t) {
        return new ItemStack(t);
    }

    public static final ItemStack stack(Block t, int s) {
        return new ItemStack(t, s);
    }

    public static final ItemStack stack(Block t, int s, int m) {
        return new ItemStack(t, s, m);
    }

    public static final ItemStack stack2(Item t) {
        return new ItemStack(t, 1, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Item t, int s) {
        return new ItemStack(t, s, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Block t) {
        return new ItemStack(t, 1, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Block t, int s) {
        return new ItemStack(t, s, Short.MAX_VALUE);
    }

    public static final IRecipe ShapedRecipe(Block result, Object ... recipe) {
        return new ShapedOreRecipe(result, recipe);
    }

    public static final IRecipe ShapedRecipe(Item result, Object ... recipe) {
        return new ShapedOreRecipe(result, recipe);
    }

    public static final IRecipe ShapedRecipe(ItemStack result, Object ... recipe) {
        return new ShapedOreRecipe(result, recipe);
    }

    public static final IRecipe ShapedRecipe(Block result, int s, Object ... recipe) {
        return new ShapedOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static final IRecipe ShapedRecipe(Item result, int s, Object ... recipe) {
        return new ShapedOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static final IRecipe ShapedRecipe(ItemStack result, int s, Object ... recipe) {
        return new ShapedOreRecipe(ItemHelper.cloneStack(result, s), recipe);
    }

    public static final IRecipe ShapelessRecipe(Block result, Object ... recipe) {
        return new ShapelessOreRecipe(result, recipe);
    }

    public static final IRecipe ShapelessRecipe(Item result, Object ... recipe) {
        return new ShapelessOreRecipe(result, recipe);
    }

    public static final IRecipe ShapelessRecipe(ItemStack result, Object ... recipe) {
        return new ShapelessOreRecipe(result, recipe);
    }

    public static final IRecipe ShapelessRecipe(Block result, int s, Object ... recipe) {
        return new ShapelessOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static final IRecipe ShapelessRecipe(Item result, int s, Object ... recipe) {
        return new ShapelessOreRecipe(ItemHelper.stack(result, s), recipe);
    }

    public static final IRecipe ShapelessRecipe(ItemStack result, int s, Object ... recipe) {
        return new ShapelessOreRecipe(ItemHelper.cloneStack(result, s), recipe);
    }

    public static boolean addGearRecipe(ItemStack gear, String ingot) {
        if (gear == null || !ItemHelper.oreNameExists(ingot)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), "ingotIron"}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, String ingot, String center) {
        if (gear == null || !ItemHelper.oreNameExists(ingot) || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, String ingot, ItemStack center) {
        if (gear == null | center == null || !ItemHelper.oreNameExists(ingot)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, ItemStack ingot, String center) {
        if (gear == null | ingot == null || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack gear, ItemStack ingot, ItemStack center) {
        if (gear == null | ingot == null | center == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(gear), (Object[])new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ItemHelper.cloneStack(ingot, 1), Character.valueOf('I'), ItemHelper.cloneStack(center, 1)});
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, String ingot, String center) {
        if (gear == null || !ItemHelper.oreNameExists(ingot) || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ingot, Character.valueOf('I'), center}));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, String ingot, ItemStack center) {
        if (gear == null | center == null || !ItemHelper.oreNameExists(ingot)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ingot, Character.valueOf('I'), center}));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, ItemStack ingot, String center) {
        if (gear == null | ingot == null || !ItemHelper.oreNameExists(center)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(gear, new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ingot, Character.valueOf('I'), center}));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack gear, ItemStack ingot, ItemStack center) {
        if (gear == null | ingot == null | center == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(gear), (Object[])new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ItemHelper.cloneStack(ingot, 1), Character.valueOf('I'), ItemHelper.cloneStack(center, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, ItemStack one, ItemStack eight) {
        if (out == null | one == null | eight == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(out), (Object[])new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(eight, 1), Character.valueOf('I'), ItemHelper.cloneStack(one, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, String one, ItemStack eight) {
        if (out == null | eight == null || !ItemHelper.oreNameExists(one)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(out, new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), eight, Character.valueOf('I'), one}));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, ItemStack one, String eight) {
        if (out == null | one == null || !ItemHelper.oreNameExists(eight)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(out, new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), eight, Character.valueOf('I'), one}));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack out, String one, String eight) {
        if (out == null || !ItemHelper.oreNameExists(one) || !ItemHelper.oreNameExists(eight)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(out, new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), eight, Character.valueOf('I'), one}));
        return true;
    }

    public static boolean addFenceRecipe(ItemStack out, ItemStack in) {
        if (out == null | in == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(out), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(in, 1)});
        return true;
    }

    public static boolean addFenceRecipe(ItemStack out, String in) {
        if (out == null || !ItemHelper.oreNameExists(in)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(out, new Object[]{"XXX", "XXX", Character.valueOf('X'), in}));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack nine, String one) {
        if (nine == null || !ItemHelper.oreNameExists(one)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ItemHelper.cloneStack(nine, 9), new Object[]{one}));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack nine, ItemStack one) {
        if (nine == null | one == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(nine, 9), (Object[])new Object[]{ItemHelper.cloneStack(one, 1)});
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack four, String one) {
        if (four == null || !ItemHelper.oreNameExists(one)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ItemHelper.cloneStack(four, 4), new Object[]{one}));
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack four, ItemStack one) {
        if (four == null | one == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(four, 4), (Object[])new Object[]{ItemHelper.cloneStack(one, 1)});
        return true;
    }

    public static boolean addStorageRecipe(ItemStack one, String nine) {
        if (one == null || !ItemHelper.oreNameExists(nine)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(one, new Object[]{nine, nine, nine, nine, nine, nine, nine, nine, nine}));
        return true;
    }

    public static boolean addStorageRecipe(ItemStack one, ItemStack nine) {
        if (one == null | nine == null) {
            return false;
        }
        nine = ItemHelper.cloneStack(nine, 1);
        GameRegistry.addShapelessRecipe((ItemStack)one, (Object[])new Object[]{nine, nine, nine, nine, nine, nine, nine, nine, nine});
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack one, String four) {
        if (one == null || !ItemHelper.oreNameExists(four)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(one, new Object[]{"XX", "XX", Character.valueOf('X'), four}));
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack one, ItemStack four) {
        if (one == null | four == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(one), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ItemHelper.cloneStack(four, 1)});
        return true;
    }

    public static boolean addTwoWayStorageRecipe(ItemStack one, ItemStack nine) {
        return ItemHelper.addStorageRecipe(one, nine) && ItemHelper.addReverseStorageRecipe(nine, one);
    }

    public static boolean addTwoWayStorageRecipe(ItemStack one, String one_ore, ItemStack nine, String nine_ore) {
        return ItemHelper.addStorageRecipe(one, nine_ore) && ItemHelper.addReverseStorageRecipe(nine, one_ore);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack one, ItemStack four) {
        return ItemHelper.addSmallStorageRecipe(one, four) && ItemHelper.addSmallReverseStorageRecipe(four, one);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack one, String one_ore, ItemStack four, String four_ore) {
        return ItemHelper.addSmallStorageRecipe(one, four_ore) && ItemHelper.addSmallReverseStorageRecipe(four, one_ore);
    }

    public static boolean addSmelting(ItemStack out, Item in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack out, Block in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack out, ItemStack in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack out, Item in, float XP) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), XP);
        return true;
    }

    public static boolean addSmelting(ItemStack out, Block in, float XP) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), XP);
        return true;
    }

    public static boolean addSmelting(ItemStack out, ItemStack in, float XP) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), XP);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack out, Item in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack out, Block in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack out, ItemStack in) {
        if (out == null | in == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(in, 1), ItemHelper.cloneStack(out), 0.1f);
        return true;
    }

    public static boolean addTwoWayConversionRecipe(ItemStack a, ItemStack b) {
        if (a == null | b == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(a, 1), (Object[])new Object[]{ItemHelper.cloneStack(b, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(b, 1), (Object[])new Object[]{ItemHelper.cloneStack(a, 1)});
        return true;
    }

    public static void registerWithHandlers(String oreName, ItemStack stack) {
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        GameRegistry.registerCustomItemStack((String)oreName, (ItemStack)stack);
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)stack);
    }

    public static void addRecipe(IRecipe recipe) {
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    public static void addRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((ItemStack)out, (Object[])recipe);
    }

    public static void addShapedRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((ItemStack)out, (Object[])recipe);
    }

    public static void addShapedRecipe(Item out, Object ... recipe) {
        ItemHelper.addRecipe(new ItemStack(out), recipe);
    }

    public static void addShapedRecipe(Block out, Object ... recipe) {
        ItemHelper.addRecipe(new ItemStack(out), recipe);
    }

    public static void addShapelessRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addShapelessRecipe((ItemStack)out, (Object[])recipe);
    }

    public static void addShapelessRecipe(Item out, Object ... recipe) {
        ItemHelper.addShapelessRecipe(new ItemStack(out), recipe);
    }

    public static void addShapelessRecipe(Block out, Object ... recipe) {
        ItemHelper.addShapelessRecipe(new ItemStack(out), recipe);
    }

    public static void addShapedOreRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, recipe));
    }

    public static void addShapedOreRecipe(Item out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, recipe));
    }

    public static void addShapedOreRecipe(Block out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(out, recipe));
    }

    public static void addShapelessOreRecipe(ItemStack out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(out, recipe));
    }

    public static void addShapelessOreRecipe(Item out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(out, recipe));
    }

    public static void addShapelessOreRecipe(Block out, Object ... recipe) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(out, recipe));
    }

    public static boolean isPlayerHoldingEmpowerableItem(EntityPlayer player) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return equipped instanceof IEmpowerableItem;
    }

    public static boolean isPlayerHoldingEmpoweredItem(EntityPlayer player) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return equipped instanceof IEmpowerableItem && ((IEmpowerableItem)equipped).isEmpowered(player.func_71045_bC());
    }

    public static boolean toggleHeldEmpowerableItemState(EntityPlayer player) {
        ItemStack equipped;
        IEmpowerableItem empowerableItem;
        return empowerableItem.setEmpoweredState(equipped, !(empowerableItem = (IEmpowerableItem)(equipped = player.func_71045_bC()).func_77973_b()).isEmpowered(equipped));
    }

    public static final boolean isPlayerHoldingFluidContainer(EntityPlayer player) {
        return FluidContainerRegistry.isContainer((ItemStack)player.func_71045_bC());
    }

    public static final boolean isPlayerHoldingFluidContainerItem(EntityPlayer player) {
        return FluidHelper.isPlayerHoldingFluidContainerItem(player);
    }

    public static final boolean isPlayerHoldingEnergyContainerItem(EntityPlayer player) {
        return EnergyHelper.isPlayerHoldingEnergyContainerItem(player);
    }

    public static final boolean isPlayerHoldingNothing(EntityPlayer player) {
        return player.func_71045_bC() == null;
    }

    public static Item getItemFromStack(ItemStack theStack) {
        return theStack == null ? null : theStack.func_77973_b();
    }

    public static boolean areItemsEqual(Item itemA, Item itemB) {
        if (itemA == null | itemB == null) {
            return false;
        }
        return itemA == itemB || itemA.equals(itemB);
    }

    public static final boolean isPlayerHoldingItem(Class<?> item, EntityPlayer player) {
        return item.isInstance(ItemHelper.getItemFromStack(player.func_71045_bC()));
    }

    public static final boolean isPlayerHoldingItem(Item item, EntityPlayer player) {
        return ItemHelper.areItemsEqual(item, ItemHelper.getItemFromStack(player.func_71045_bC()));
    }

    public static final boolean isPlayerHoldingItemStack(ItemStack stack, EntityPlayer player) {
        return ItemHelper.itemsEqualWithMetadata(stack, player.func_71045_bC());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB) {
        if (stackA == null | stackB == null) {
            return false;
        }
        return ItemHelper.areItemsEqual(stackA.func_77973_b(), stackB.func_77973_b());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!checkNBT || ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d));
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!stackA.func_77981_g() || stackA.func_77960_j() == stackB.func_77960_j());
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return ItemHelper.itemsEqualWithMetadata(stackA, stackB) && (!checkNBT || ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d));
    }

    public static boolean itemsIdentical(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && stackA.func_77960_j() == stackB.func_77960_j() && ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d);
    }

    public static boolean doNBTsMatch(NBTTagCompound nbtA, NBTTagCompound nbtB) {
        if (nbtA == null & nbtB == null) {
            return true;
        }
        if (nbtA != null & nbtB != null) {
            return nbtA.equals((Object)nbtB);
        }
        return false;
    }

    public static boolean itemsEqualForCrafting(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!stackA.func_77981_g() || stackA.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == stackA.func_77960_j());
    }

    public static boolean craftingEquivalent(ItemStack checked, ItemStack source, String oreDict, ItemStack output) {
        if (ItemHelper.itemsEqualForCrafting(checked, source)) {
            return true;
        }
        if (output != null && ItemHelper.isBlacklist(output)) {
            return false;
        }
        if (oreDict == null || oreDict.equals("Unknown")) {
            return false;
        }
        return ItemHelper.getOreName(checked).equalsIgnoreCase(oreDict);
    }

    public static boolean doOreIDsMatch(ItemStack stackA, ItemStack stackB) {
        int id = oreProxy.getOreID(stackA);
        return id >= 0 && id == oreProxy.getOreID(stackB);
    }

    public static boolean isBlacklist(ItemStack output) {
        Item item = output.func_77973_b();
        return Item.func_150898_a((Block)Blocks.field_150487_bG) == item || Item.func_150898_a((Block)Blocks.field_150481_bH) == item || Item.func_150898_a((Block)Blocks.field_150476_ad) == item || Item.func_150898_a((Block)Blocks.field_150485_bF) == item || Item.func_150898_a((Block)Blocks.field_150344_f) == item || Item.func_150898_a((Block)Blocks.field_150376_bx) == item;
    }

    public static String getItemNBTString(ItemStack theItem, String nbtKey, String invalidReturn) {
        return theItem.field_77990_d != null && theItem.field_77990_d.func_74764_b(nbtKey) ? theItem.field_77990_d.func_74779_i(nbtKey) : invalidReturn;
    }

    public static void addInventoryInformation(ItemStack stack, List<String> list) {
        ItemHelper.addInventoryInformation(stack, list, 0, Integer.MAX_VALUE);
    }

    public static void addInventoryInformation(ItemStack stack, List<String> list, int minSlot, int maxSlot) {
        if (stack.field_77990_d == null) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        if (stack.func_77973_b() instanceof IInventoryContainerItem && stack.field_77990_d.func_74764_b("Accessible")) {
            ItemHelper.addAccessibleInventoryInformation(stack, list, minSlot, maxSlot);
            return;
        }
        if (!stack.field_77990_d.func_74764_b("Inventory") || stack.field_77990_d.func_150295_c("Inventory", (int)stack.field_77990_d.func_74732_a()).func_74745_c() <= 0) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        NBTTagList nbtList = stack.field_77990_d.func_150295_c("Inventory", (int)stack.field_77990_d.func_74732_a());
        ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
        boolean[] visited = new boolean[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtList.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (visited[i] || slot < minSlot || slot > maxSlot) continue;
            visited[i] = true;
            ItemStack curStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (curStack == null) continue;
            containedItems.add(curStack);
            for (int j = 0; j < nbtList.func_74745_c(); ++j) {
                ItemStack curStack2;
                NBTTagCompound tag2 = nbtList.func_150305_b(j);
                int slot2 = tag.func_74762_e("Slot");
                if (visited[j] || slot2 < minSlot || slot2 > maxSlot || (curStack2 = ItemStack.func_77949_a((NBTTagCompound)tag2)) == null || !ItemHelper.itemsEqualWithMetadata(curStack, curStack2)) continue;
                curStack.field_77994_a += curStack2.field_77994_a;
                visited[j] = true;
            }
        }
        if (containedItems.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        }
        for (ItemStack item : containedItems) {
            int maxStackSize = item.func_77976_d();
            if (!StringHelper.displayStackCount || item.field_77994_a < maxStackSize || maxStackSize == 1) {
                list.add("    \u00a7a" + item.field_77994_a + " " + StringHelper.getItemName(item));
                continue;
            }
            if (item.field_77994_a % maxStackSize != 0) {
                list.add("    \u00a7a" + maxStackSize + "x" + item.field_77994_a / maxStackSize + "+" + item.field_77994_a % maxStackSize + " " + StringHelper.getItemName(item));
                continue;
            }
            list.add("    \u00a7a" + maxStackSize + "x" + item.field_77994_a / maxStackSize + " " + StringHelper.getItemName(item));
        }
    }

    public static void addAccessibleInventoryInformation(ItemStack stack, List<String> list, int minSlot, int maxSlot) {
        int invSize = ((IInventoryContainerItem)stack.func_77973_b()).getSizeInventory(stack);
        ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
        boolean[] visited = new boolean[invSize];
        for (int i = minSlot; i < Math.min(invSize, maxSlot); ++i) {
            if (visited[i] || !stack.field_77990_d.func_74764_b("Slot" + i)) continue;
            ItemStack curStack = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("Slot" + i));
            visited[i] = true;
            if (curStack == null) continue;
            containedItems.add(curStack);
            for (int j = minSlot; j < Math.min(invSize, maxSlot); ++j) {
                ItemStack curStack2;
                if (visited[j] || !stack.field_77990_d.func_74764_b("Slot" + j) || (curStack2 = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("Slot" + j))) == null || !ItemHelper.itemsEqualWithMetadata(curStack, curStack2)) continue;
                curStack.field_77994_a += curStack2.field_77994_a;
                visited[j] = true;
            }
        }
        if (containedItems.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        } else {
            list.add(StringHelper.localize("info.cofh.empty"));
        }
        for (ItemStack item : containedItems) {
            int maxStackSize = item.func_77976_d();
            if (!StringHelper.displayStackCount || item.field_77994_a < maxStackSize || maxStackSize == 1) {
                list.add("    \u00a7a" + item.field_77994_a + " " + StringHelper.getItemName(item));
                continue;
            }
            if (item.field_77994_a % maxStackSize != 0) {
                list.add("    \u00a7a" + maxStackSize + "x" + item.field_77994_a / maxStackSize + "+" + item.field_77994_a % maxStackSize + " " + StringHelper.getItemName(item));
                continue;
            }
            list.add("    \u00a7a" + maxStackSize + "x" + item.field_77994_a / maxStackSize + " " + StringHelper.getItemName(item));
        }
    }
}

