/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.MathHelper;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FireworksHelper {
    public static Firework getRandomFirework() {
        Firework firework = new Firework();
        int v = MathHelper.RANDOM.nextInt(4);
        switch (v) {
            case 0: 
            case 2: {
                firework.setFlicker(true);
                if (v == 0) break;
            }
            case 1: {
                firework.setTrail(true);
            }
        }
        firework.setType(MathHelper.RANDOM.nextInt(5));
        for (int i = 0; i <= MathHelper.RANDOM.nextInt(3); ++i) {
            Color randomColor = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
            firework.addColor(randomColor.getRed(), randomColor.getGreen(), randomColor.getBlue());
        }
        return firework;
    }

    public static class Firework {
        private int flightDuration = 0;
        private boolean flicker = false;
        private boolean trail = false;
        private ArrayList<Integer> colors = new ArrayList();
        private FireworkType type = FireworkType.BALL;

        public Firework setFlightDuration(int duration) {
            this.flightDuration = MathHelper.clampI(duration, 0, 3);
            return this;
        }

        public Firework setFlicker(boolean flicker) {
            this.flicker = flicker;
            return this;
        }

        public Firework setTrail(boolean trail) {
            this.trail = trail;
            return this;
        }

        public Firework setType(FireworkType type) {
            this.type = type;
            return this;
        }

        public Firework setType(int type) {
            this.setType(FireworkType.values()[MathHelper.clampI(type, 0, FireworkType.values().length - 1)]);
            return this;
        }

        public Firework addColor(int red, int green, int blue) {
            this.colors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        public ItemStack getStack() {
            NBTTagCompound explosionTag = new NBTTagCompound();
            explosionTag.func_74757_a("Flicker", this.flicker);
            explosionTag.func_74757_a("Trail", this.trail);
            explosionTag.func_74774_a("Type", (byte)this.type.ordinal());
            int[] colorArray = new int[this.colors.size()];
            for (int i = 0; i < this.colors.size(); ++i) {
                colorArray[i] = this.colors.get(i);
            }
            explosionTag.func_74783_a("Colors", colorArray);
            NBTTagCompound tags = new NBTTagCompound();
            NBTTagCompound fireworksTag = new NBTTagCompound();
            NBTTagList explosionsList = new NBTTagList();
            explosionsList.func_74742_a((NBTBase)explosionTag);
            fireworksTag.func_74774_a("Flight", (byte)this.flightDuration);
            fireworksTag.func_74782_a("Explosions", (NBTBase)explosionsList);
            tags.func_74782_a("Fireworks", (NBTBase)fireworksTag);
            ItemStack stack = new ItemStack(Items.field_151152_bP);
            stack.func_77982_d(tags);
            return stack;
        }
    }

    public static enum FireworkType {
        BALL,
        LARGE_BALL,
        STAR,
        CREEPER,
        BURST;

    }
}

