/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.FurnaceManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Furnace")
public class Furnace {
    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(energy, InputHelper.toStack(input), InputHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input)));
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            FurnaceManager.loadRecipes();
        }

        public boolean canUndo() {
            return false;
        }

        public String describe() {
            return "Refreshing Redstone Furnace Recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Can't Undo Redstone Furnace Refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        ItemStack input;
        FurnaceManager.RecipeFurnace removed;

        public Remove(ItemStack inp) {
            this.input = inp;
        }

        public void apply() {
            this.removed = FurnaceManager.getRecipe((ItemStack)this.input);
            FurnaceManager.removeRecipe((ItemStack)this.input);
        }

        public boolean canUndo() {
            return this.removed != null;
        }

        public String describe() {
            return "Removing Redstone Furnace Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            FurnaceManager.addRecipe((int)this.removed.getEnergy(), (ItemStack)this.removed.getInput(), (ItemStack)this.removed.getOutput(), (boolean)false);
        }

        public String describeUndo() {
            return "Restoring Redstone Furnace Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        ItemStack input;
        ItemStack output;
        int energy;
        boolean applied = false;

        public Add(int rf, ItemStack inp, ItemStack out) {
            this.energy = rf;
            this.input = inp;
            this.output = out;
        }

        public void apply() {
            FurnaceManager.addRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.output, (boolean)false);
        }

        public boolean canUndo() {
            return this.input != null;
        }

        public String describe() {
            return "Adding Redstone Furnace Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            FurnaceManager.removeRecipe((ItemStack)this.input);
        }

        public String describeUndo() {
            return "Removing Redstone Furnace Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

