/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.CrucibleManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Crucible")
public class Crucible {
    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, ILiquidStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(energy, InputHelper.toStack(input), InputHelper.toFluid(output)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input)));
    }

    private static class Remove
    implements IUndoableAction {
        ItemStack input;
        CrucibleManager.RecipeCrucible removed;

        public Remove(ItemStack inp) {
            this.input = inp;
        }

        public void apply() {
            this.removed = CrucibleManager.getRecipe((ItemStack)this.input);
            ThermalHelper.removeCrucibleRecipe(this.input);
        }

        public boolean canUndo() {
            return this.removed != null;
        }

        public String describe() {
            return "Removing TE Magma Crucible Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            CrucibleManager.addRecipe((int)this.removed.getEnergy(), (ItemStack)this.removed.getInput(), (FluidStack)this.removed.getOutput());
        }

        public String describeUndo() {
            return "Restoring TE Magma Crucible Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        ItemStack input;
        FluidStack output;
        int energy;
        boolean applied = false;

        public Add(int rf, ItemStack inp, FluidStack out) {
            this.energy = rf;
            this.input = inp;
            this.output = out;
        }

        public void apply() {
            this.applied = CrucibleManager.addRecipe((int)this.energy, (ItemStack)this.input, (FluidStack)this.output);
        }

        public boolean canUndo() {
            return this.input != null && this.applied;
        }

        public String describe() {
            return "Adding TE Magma Crucible Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            ThermalHelper.removeCrucibleRecipe(this.input);
        }

        public String describeUndo() {
            return "Removing TE Magma Crucible Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

