/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;

@ZenClass(value="mods.thaumcraft.Arcane")
public class Arcane {
    @ZenMethod
    public static void addShaped(String key, IItemStack output, String aspects, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IArcaneRecipe)new ShapedArcaneRecipe(key, InputHelper.toStack(output), ThaumcraftHelper.parseAspects(aspects), InputHelper.toShapedObjects(ingredients))));
    }

    @ZenMethod
    public static void addShapeless(String key, IItemStack output, String aspects, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IArcaneRecipe)new ShapelessArcaneRecipe(key, InputHelper.toStack(output), ThaumcraftHelper.parseAspects(aspects), InputHelper.toObjects(ingredients))));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Thaumcraft Arcane Worktable", ThaumcraftApi.getCraftingRecipes(), stack);
        }

        public void apply() {
            ArrayList<IArcaneRecipe> recipesToRemove = new ArrayList<IArcaneRecipe>();
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                IArcaneRecipe r;
                if (o == null || !(o instanceof IArcaneRecipe) || (r = (IArcaneRecipe)o).getRecipeOutput() == null || !r.getRecipeOutput().func_77969_a(this.stack)) continue;
                recipesToRemove.add(r);
            }
            for (IArcaneRecipe r : recipesToRemove) {
                ThaumcraftApi.getCraftingRecipes().remove(r);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(IArcaneRecipe recipe) {
            super("Thaumcraft Arcane Worktable", ThaumcraftApi.getCraftingRecipes(), recipe);
        }

        @Override
        public String getRecipeInfo() {
            ItemStack out = ((IArcaneRecipe)this.recipe).getRecipeOutput();
            if (out instanceof ItemStack) {
                return out.func_82833_r();
            }
            return super.getRecipeInfo();
        }
    }
}

