/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.ToolMaterial;

@ZenClass(value="mods.tconstruct.ToolStats")
public class ToolStats {
    @ZenMethod
    public static void set(String material, @Optional String name, int level, int durability, int speed, int damage, double handle, int reinforced, double stonebound, String style, String ability) {
        if (name == null) {
            name = material + " ";
        }
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "", new ToolMaterial(material, name, level, durability, speed, damage, (float)handle, reinforced, (float)stonebound, style, ability)));
    }

    @ZenMethod
    public static void setDisplayName(String material, String name) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "displayName", name));
    }

    @ZenMethod
    public static void setHarvestLevel(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "harvestLevel", value));
    }

    @ZenMethod
    public static void setDurability(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "durability", value));
    }

    @ZenMethod
    public static void setSpeed(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "miningspeed", value));
    }

    @ZenMethod
    public static void setDamage(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "attack", value));
    }

    @ZenMethod
    public static void setHandleModifier(String material, double value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "handleModifier", Float.valueOf((float)value)));
    }

    @ZenMethod
    public static void setReinforcedLevel(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "reinforced", value));
    }

    @ZenMethod
    public static void setStoneboundLevel(String material, double value) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "stonebound", Float.valueOf((float)value)));
    }

    @ZenMethod
    public static void setStyle(String material, String name) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "tipStyle", name));
    }

    @ZenMethod
    public static void setAbility(String material, String name) {
        MineTweakerAPI.apply((IUndoableAction)new SetToolStats(material, "ability", name));
    }

    @ZenMethod
    public static void setBowStats(String material, int durability, int drawspeed, double flightspeed) {
        MineTweakerAPI.apply((IUndoableAction)new SetBowStats(material, "", new BowMaterial(durability, drawspeed, (float)flightspeed)));
    }

    @ZenMethod
    public static void setBowDurability(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetBowStats(material, "durability", value));
    }

    @ZenMethod
    public static void setBowDrawspeed(String material, int value) {
        MineTweakerAPI.apply((IUndoableAction)new SetBowStats(material, "drawspeed", value));
    }

    @ZenMethod
    public static void setBowFlightSpeed(String material, double value) {
        MineTweakerAPI.apply((IUndoableAction)new SetBowStats(material, "flightSpeedMax", Float.valueOf((float)value)));
    }

    @ZenMethod
    public static void setArrowStats(String material, double mass, double breakChance, double accuracy) {
        MineTweakerAPI.apply((IUndoableAction)new SetArrowStats(material, "", new ArrowMaterial((float)mass, (float)breakChance, (float)accuracy)));
    }

    @ZenMethod
    public static void setArrowMass(String material, double value) {
        MineTweakerAPI.apply((IUndoableAction)new SetArrowStats(material, "mass", Float.valueOf((float)value)));
    }

    @ZenMethod
    public static void setArrowBreakChance(String material, double value) {
        MineTweakerAPI.apply((IUndoableAction)new SetArrowStats(material, "breakChance", Float.valueOf((float)value)));
    }

    @ZenMethod
    public static void setArrowAccuracy(String material, double value) {
        MineTweakerAPI.apply((IUndoableAction)new SetArrowStats(material, "accuracy", Float.valueOf((float)value)));
    }

    private static class SetArrowStats
    extends SetToolStats {
        public SetArrowStats(String material, String field, Object value) {
            super(material, field, value);
        }

        @Override
        public void apply() {
            this.id = TConstructHelper.getIDFromString(this.material);
            this.old = TConstructRegistry.arrowMaterials.get(this.id);
            if (this.id != -1 && this.old != null) {
                if (this.value instanceof ArrowMaterial) {
                    this.fresh = (ArrowMaterial)this.value;
                } else {
                    ArrowMaterial a = (ArrowMaterial)this.old;
                    this.fresh = new ArrowMaterial(a.mass, a.breakChance, a.accuracy);
                    ReflectionHelper.setPrivateValue(ArrowMaterial.class, this.fresh, this.field, this.value);
                }
                TConstructRegistry.arrowMaterials.put(this.id, (ArrowMaterial)this.fresh);
            }
        }

        @Override
        public boolean canUndo() {
            return TConstructRegistry.arrowMaterials != null && this.id != -1 && this.old != null;
        }

        @Override
        public void undo() {
            TConstructRegistry.arrowMaterials.put(this.id, (ArrowMaterial)this.old);
        }
    }

    private static class SetBowStats
    extends SetToolStats {
        public SetBowStats(String material, String field, Object value) {
            super(material, field, value);
        }

        @Override
        public void apply() {
            this.id = TConstructHelper.getIDFromString(this.material);
            this.old = TConstructRegistry.bowMaterials.get(this.id);
            if (this.id != -1 && this.old != null) {
                if (this.value instanceof BowMaterial) {
                    this.fresh = (BowMaterial)this.value;
                } else {
                    BowMaterial b = (BowMaterial)this.old;
                    this.fresh = new BowMaterial(b.durability, b.drawspeed, b.flightSpeedMax);
                    ReflectionHelper.setPrivateValue(BowMaterial.class, this.fresh, this.field, this.value);
                }
                TConstructRegistry.bowMaterials.put(this.id, (BowMaterial)this.fresh);
            }
        }

        @Override
        public boolean canUndo() {
            return TConstructRegistry.bowMaterials != null && this.id != -1 && this.old != null;
        }

        @Override
        public void undo() {
            TConstructRegistry.bowMaterials.put(this.id, (BowMaterial)this.old);
        }
    }

    private static class SetToolStats
    implements IUndoableAction {
        protected int id;
        protected Object old;
        protected Object fresh;
        protected final String material;
        protected final String field;
        protected final Object value;

        public SetToolStats(String material, String field, Object value) {
            this.material = material;
            this.field = field;
            this.value = value;
        }

        public void apply() {
            this.old = TConstructRegistry.toolMaterialStrings.get(this.material);
            this.id = TConstructHelper.getIDFromString(this.material);
            if (this.id != -1 && this.old != null) {
                if (this.value instanceof ToolMaterial) {
                    this.fresh = (ToolMaterial)this.value;
                } else {
                    ToolMaterial t = (ToolMaterial)this.old;
                    this.fresh = new ToolMaterial(t.materialName, t.displayName, t.harvestLevel, t.durability, t.miningspeed, t.attack, t.handleModifier, t.reinforced, t.stonebound, t.tipStyle, t.ability);
                    ReflectionHelper.setPrivateValue(ToolMaterial.class, this.fresh, this.field, this.value);
                }
                TConstructRegistry.toolMaterials.put(this.id, (ToolMaterial)this.fresh);
                TConstructRegistry.toolMaterialStrings.put(this.material, (ToolMaterial)this.fresh);
            }
        }

        public boolean canUndo() {
            return TConstructRegistry.toolMaterialStrings != null && this.id != -1 && this.old != null;
        }

        public void undo() {
            TConstructRegistry.toolMaterials.put(this.id, (ToolMaterial)this.old);
            TConstructRegistry.toolMaterialStrings.put(this.material, (ToolMaterial)this.old);
        }

        public String describe() {
            return "Changing material stats field : + " + this.field + " for " + this.material;
        }

        public String describeUndo() {
            return "Undoing change of material stats field : + " + this.field + " for " + this.material;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

