/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.RockCrusher")
public class RockCrusher {
    @ZenMethod
    public static void addRecipe(IItemStack input, boolean matchDamage, boolean matchNBT, IItemStack[] output, double[] chances) {
        IRockCrusherRecipe recipe = RailcraftHelper.getRockCrusherRecipe(InputHelper.toStack(input), matchDamage, matchNBT);
        for (int i = 0; i < output.length; ++i) {
            recipe.addOutput(InputHelper.toStack(output[i]), (float)chances[i]);
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Rock Crusher", RailcraftHelper.crusher, stack);
        }

        public void apply() {
            for (IRockCrusherRecipe iRockCrusherRecipe : RailcraftHelper.crusher) {
                if (iRockCrusherRecipe.getInput() == null || !StackHelper.areEqual(iRockCrusherRecipe.getInput(), this.stack)) continue;
                this.recipe = iRockCrusherRecipe;
                break;
            }
            RailcraftHelper.crusher.remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(IRockCrusherRecipe recipe) {
            super("Rock Crusher", RailcraftHelper.crusher, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((IRockCrusherRecipe)this.recipe).getInput().func_82833_r();
        }
    }
}

