/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.gadgets.MachineCarpenter;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.forestry.ForestryHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Carpenter")
public class Carpenter {
    @ZenMethod
    public static void addRecipe(int packagingTime, ILiquidStack liquid, IItemStack[] ingredients, IItemStack ingredient, IItemStack product) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : InputHelper.toStacks(ingredients)) {
            if (stack != null) {
                stacks.add(stack);
            }
            if (stack != null) continue;
            stacks.add(new ItemStack(Blocks.field_150350_a));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineCarpenter.Recipe(packagingTime, InputHelper.toFluid(liquid), InputHelper.toStack(ingredient), new ShapedRecipeCustom(3, 3, (Object[])InputHelper.toStacks(ingredients), InputHelper.toStack(product)))));
    }

    public ShapedRecipeCustom convertToRecipeCustom() {
        return null;
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove((List)MachineCarpenter.RecipeManager.recipes, InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(List list, ItemStack stack) {
            super("Forestry Carpenter", list, stack);
        }

        public void apply() {
            for (MachineCarpenter.Recipe r : MachineCarpenter.RecipeManager.recipes) {
                if (r.getCraftingResult() == null || !r.getCraftingResult().func_77969_a(this.stack)) continue;
                this.recipe = r;
                break;
            }
            MachineCarpenter.RecipeManager.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return "Removed recipe for: " + this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(MachineCarpenter.Recipe recipe) {
            super("Forestry Carpenter", MachineCarpenter.RecipeManager.recipes, recipe);
            if (recipe.getLiquid() != null) {
                ForestryHelper.addCarpenterRecipeFluids(recipe.getLiquid().getFluid());
            }
            if (!MachineCarpenter.RecipeManager.isBox((ItemStack)recipe.getBox())) {
                ForestryHelper.addCarpenterRecipeBox(recipe.getBox());
            }
        }

        @Override
        public String getRecipeInfo() {
            return ((MachineCarpenter.Recipe)this.recipe).getCraftingResult().func_82833_r();
        }
    }
}

