/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.factorization.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.factorization.FactorizationHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseMultipleListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorization.SlagFurnace")
public class SlagFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output2, double chance2, IItemStack output1, double chance1) {
        Object recipe = FactorizationHelper.getSlagFurnaceRecipe(InputHelper.toStack(input), (float)chance1, InputHelper.toStack(output1), (float)chance2, InputHelper.toStack(output2));
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(input), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input), BaseMultipleListRemoval.Position.ALL));
    }

    @ZenMethod
    public static void removeFirst(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output), BaseMultipleListRemoval.Position.FIRST));
    }

    @ZenMethod
    public static void removeLast(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output), BaseMultipleListRemoval.Position.LAST));
    }

    private static class Remove
    extends BaseMultipleListRemoval {
        public Remove(ItemStack stack, BaseMultipleListRemoval.Position pos) {
            super("Slag Furnace", FactorizationHelper.slag, stack, pos);
        }

        @Override
        protected boolean isEqual(Object recipe, Object search) {
            ItemStack input = (ItemStack)ReflectionHelper.getObject(recipe, "input");
            return input != null && StackHelper.areEqual(input, (ItemStack)search);
        }

        @Override
        public String getRecipeInfo() {
            return ((ItemStack)this.search).func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        private final ItemStack input;

        public Add(ItemStack input, Object recipe) {
            super("Slag Furnace", FactorizationHelper.slag, recipe);
            this.input = input;
        }

        @Override
        public String getRecipeInfo() {
            return this.input.func_82833_r();
        }
    }
}

