/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.extendedworkbench.handlers;

import java.util.Arrays;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import naruto1310.extendedWorkbench.crafting.ExtendedCraftingManager;
import naruto1310.extendedWorkbench.crafting.ExtendedShapedRecipes;
import naruto1310.extendedWorkbench.crafting.ExtendedShapelessRecipes;
import naruto1310.extendedWorkbench.crafting.IExtendedRecipe;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedworkbench")
public class ExtendedCrafting {
    @ZenMethod
    public static void addShaped(IItemStack output, IItemStack[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(ExtendedCrafting.getShapedRecipe(output, ingredients)));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IItemStack[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IExtendedRecipe)new ExtendedShapelessRecipes(InputHelper.toStack(output), Arrays.asList(InputHelper.toStacks(ingredients)))));
    }

    private static IExtendedRecipe getShapedRecipe(IItemStack out, IItemStack[][] ingredients) {
        int width = 0;
        int height = ingredients.length;
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null || ingredients[x].length <= width) continue;
            width = ingredients[x].length;
        }
        ItemStack[] recipe = new ItemStack[width * height];
        int counter = 0;
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                recipe[counter++] = InputHelper.toStack(ingredients[x][y]);
            }
        }
        return new ExtendedShapedRecipes(width, height, recipe, InputHelper.toStack(out));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Extended Workbench", ExtendedCraftingManager.getInstance().getRecipeList(), stack);
        }

        public void apply() {
            for (Object o : ExtendedCraftingManager.getInstance().getRecipeList()) {
                IExtendedRecipe r;
                if (!(o instanceof IExtendedRecipe) || (r = (IExtendedRecipe)o).func_77571_b() == null || !StackHelper.areEqual(r.func_77571_b(), this.stack)) continue;
                this.recipe = r;
                break;
            }
            ExtendedCraftingManager.getInstance().getRecipeList().remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(IExtendedRecipe recipe) {
            super("Extended Workbench", ExtendedCraftingManager.getInstance().getRecipeList(), recipe);
        }

        @Override
        public String getRecipeInfo() {
            ItemStack out = ((IExtendedRecipe)this.recipe).func_77571_b();
            if (out != null) {
                return out.func_82833_r();
            }
            return super.getRecipeInfo();
        }
    }
}

