/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.config;

import com.google.common.base.Preconditions;
import com.nauktis.solarflux.SolarFluxMod;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ModConfiguration {
    private static Configuration mConfiguration;
    private static float mSolarPanelHeight;
    private static boolean mAutoBalanceEnergy;
    private static boolean mUseThermalExpansionRecipes;
    private static boolean mKeepEnergyWhenDismantled;
    private static float mRainGenerationFactor;
    private static float mThunderGenerationFactor;

    public static void initialize(File pConfigFile) {
        SolarFluxMod.log.info("Initialization of configuration", new Object[0]);
        if (mConfiguration == null) {
            mConfiguration = new Configuration(pConfigFile);
        }
        FMLCommonHandler.instance().bus().register((Object)new ModConfiguration());
        ModConfiguration.loadConfiguration();
    }

    private static void loadConfiguration() {
        Preconditions.checkNotNull((Object)mConfiguration);
        mSolarPanelHeight = mConfiguration.getFloat("SolarPanelHeight", "general", 0.375f, 0.1f, 1.0f, "The height of the Solar Panel blocks.");
        mAutoBalanceEnergy = mConfiguration.getBoolean("BalanceEnergy", "general", true, "Neighbor solar panels share their energy if set to true.");
        mUseThermalExpansionRecipes = mConfiguration.getBoolean("UseThermalExpansionRecipes", "general", true, "Use Thermal Expansion recipes.");
        mKeepEnergyWhenDismantled = mConfiguration.getBoolean("KeepEnergyWhenDismantled", "general", true, "Whether or not the solar panels keep their internal energy when dismantled with a wrench.");
        mRainGenerationFactor = mConfiguration.getFloat("RainProductionFactor", "general", 0.2f, 0.0f, 1.0f, "Factor used to reduce the energy generation during rainy weather.");
        mThunderGenerationFactor = mConfiguration.getFloat("ThunderProductionFactor", "general", 0.2f, 0.0f, 1.0f, "Factor used to reduce the energy generation during stormy weather.");
        if (mConfiguration.hasChanged()) {
            SolarFluxMod.log.info("Configuration saved", new Object[0]);
            mConfiguration.save();
        }
    }

    public static Configuration getConfiguration() {
        return mConfiguration;
    }

    public static float getSolarPanelHeight() {
        return mSolarPanelHeight;
    }

    public static boolean isSolarPanelFullBlock() {
        return mSolarPanelHeight == 1.0f;
    }

    public static boolean doesAutoBalanceEnergy() {
        return mAutoBalanceEnergy;
    }

    public static boolean useThermalExpansionRecipes() {
        return mUseThermalExpansionRecipes;
    }

    public static boolean doesKeepEnergyWhenDismantled() {
        return mKeepEnergyWhenDismantled;
    }

    public static float getRainGenerationFactor() {
        return mRainGenerationFactor;
    }

    public static float getThunderGenerationFactor() {
        return mThunderGenerationFactor;
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent pEvent) {
        if (pEvent.modID.equalsIgnoreCase("SolarFlux")) {
            ModConfiguration.loadConfiguration();
        }
    }
}

