/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2;

import ic2.api.tile.ExplosionWhitelist;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.ExplosionWhitelist")
@ModOnly(value={"IC2"})
public class IC2ExplosionWhitelist {
    @ZenMethod
    public static void add(IItemStack item) {
        ItemStack iStack = MineTweakerMC.getItemStack(item);
        Block block = Block.func_149634_a((Item)iStack.func_77973_b());
        if (block == null) {
            MineTweakerAPI.logError("This item is not a block");
        } else {
            MineTweakerAPI.apply(new AddAction(block));
        }
    }

    @ZenMethod
    public static void remove(IItemStack item) {
        ItemStack iStack = MineTweakerMC.getItemStack(item);
        Block block = Block.func_149634_a((Item)iStack.func_77973_b());
        if (block == null) {
            MineTweakerAPI.logError("This item is not a block");
        } else if (ExplosionWhitelist.isBlockWhitelisted((Block)block)) {
            MineTweakerAPI.logWarning("This block is not in the whitelist");
        } else {
            MineTweakerAPI.apply(new RemoveAction(block));
        }
    }

    @ZenMethod
    public static boolean isWhitelisted(IItemStack item) {
        ItemStack iStack = MineTweakerMC.getItemStack(item);
        Block block = Block.func_149634_a((Item)iStack.func_77973_b());
        if (block == null) {
            MineTweakerAPI.logWarning("This item is not a block");
            return false;
        }
        return ExplosionWhitelist.isBlockWhitelisted((Block)block);
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final Block block;

        public RemoveAction(Block block) {
            this.block = block;
        }

        @Override
        public void apply() {
            ExplosionWhitelist.removeWhitelistedBlock((Block)this.block);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            ExplosionWhitelist.addWhitelistedBlock((Block)this.block);
        }

        @Override
        public String describe() {
            return "Removing block from IC2 explosion whitelist: " + this.block.func_149732_F();
        }

        @Override
        public String describeUndo() {
            return "Adding block to IC2 explosion whitelist: " + this.block.func_149732_F();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddAction
    implements IUndoableAction {
        private final Block block;

        public AddAction(Block block) {
            this.block = block;
        }

        @Override
        public void apply() {
            ExplosionWhitelist.addWhitelistedBlock((Block)this.block);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            ExplosionWhitelist.removeWhitelistedBlock((Block)this.block);
        }

        @Override
        public String describe() {
            return "Adding block to IC2 explosion whitelist: " + this.block.func_149732_F();
        }

        @Override
        public String describeUndo() {
            return "Removing block from IC2 explosion whitelist: " + this.block.func_149732_F();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

