/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities;

import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.localization.WailaText;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.networking.TileCableBus;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.IWailaSource;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.registries.EnumCache;
import thaumicenergistics.util.EffectiveSide;

public abstract class TileProviderBase
extends AENetworkTile
implements IColorableTile,
IWailaSource {
    protected static final String NBT_KEY_COLOR = "TEColor";
    protected static final String NBT_KEY_ATTACHMENT = "TEAttachSide";
    protected static final String NBT_KEY_ISCOLORFORCED = "ColorForced";
    private MachineSource asMachineSource = new MachineSource((IActionHost)this);
    protected int attachmentSide;
    protected IMEMonitor<IAEFluidStack> monitor = null;
    protected boolean isActive;
    protected boolean isColorForced = false;

    private AEColor[] getNeighborCableColors() {
        AEColor[] sideColors = new AEColor[6];
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (tileEntity == null || !(tileEntity instanceof TileCableBus)) continue;
            sideColors[side.ordinal()] = ((TileCableBus)tileEntity).getColor();
        }
        return sideColors;
    }

    protected int extractEssentiaFromNetwork(Aspect wantedAspect, int wantedAmount, boolean mustMatch) {
        if (this.getFluidMonitor()) {
            GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(wantedAspect);
            if (essentiaGas == null) {
                return 0;
            }
            IAEFluidStack request = EssentiaConversionHelper.instance.createAEFluidStackInEssentiaUnits(essentiaGas, wantedAmount);
            IAEFluidStack fluidStack = (IAEFluidStack)this.monitor.extractItems((IAEStack)request, Actionable.SIMULATE, (BaseActionSource)this.asMachineSource);
            if (fluidStack == null) {
                return 0;
            }
            if (mustMatch && fluidStack.getStackSize() != EssentiaConversionHelper.instance.convertEssentiaAmountToFluidAmount(wantedAmount)) {
                return 0;
            }
            this.monitor.extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)this.asMachineSource);
            return (int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize());
        }
        return 0;
    }

    protected AspectStack getAspectStackFromNetwork(Aspect searchAspect) {
        List<AspectStack> aspectStackList = this.getNetworkAspects();
        if (aspectStackList != null && !aspectStackList.isEmpty()) {
            for (AspectStack currentStack : aspectStackList) {
                if (currentStack.aspect != searchAspect) continue;
                return currentStack;
            }
        }
        return null;
    }

    protected boolean getFluidMonitor() {
        IGridNode node = this.gridProxy.getNode();
        if (node == null) {
            return false;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return false;
        }
        IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
        this.monitor = storageGrid.getFluidInventory();
        return this.monitor != null;
    }

    protected abstract double getIdlePowerusage();

    protected abstract ItemStack getItemFromTile(Object var1);

    protected List<AspectStack> getNetworkAspects() {
        if (this.getFluidMonitor()) {
            return EssentiaConversionHelper.instance.convertIIAEFluidStackListToAspectStackList((IItemList<IAEFluidStack>)this.monitor.getStorageList());
        }
        return null;
    }

    protected int injectEssentiaIntoNetwork(Aspect aspect, int amount, Actionable mode) {
        if (amount == 0) {
            return 0;
        }
        if (this.getFluidMonitor()) {
            GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
            if (essentiaGas == null) {
                return 0;
            }
            IAEFluidStack request = EssentiaConversionHelper.instance.createAEFluidStackInEssentiaUnits(essentiaGas, amount);
            IAEFluidStack fluidStack = (IAEFluidStack)this.monitor.injectItems((IAEStack)request, mode, (BaseActionSource)this.asMachineSource);
            if (fluidStack == null) {
                return amount;
            }
            return amount - (int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize());
        }
        return 0;
    }

    protected abstract void onChannelUpdate();

    protected void setProviderColor(AEColor gridColor) {
        this.gridProxy.myColor = gridColor;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            IGridNode gridNode = this.gridProxy.getNode();
            if (gridNode != null) {
                this.gridProxy.getNode().updateState();
            }
            this.markForUpdate();
            this.saveChanges();
        }
    }

    @Override
    public void addWailaInformation(List<String> tooltip) {
        if (this.isActive()) {
            tooltip.add(WailaText.DeviceOnline.getLocal());
        } else {
            tooltip.add(WailaText.DeviceOffline.getLocal());
        }
        tooltip.add("Color: " + this.getColor().toString());
    }

    @MENetworkEventSubscribe
    public final void channelEvent(MENetworkChannelsChanged event) {
        this.checkGridConnectionColor();
        this.onChannelUpdate();
        this.markForUpdate();
    }

    public void checkGridConnectionColor() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || this.field_145850_b == null) {
            return;
        }
        if (this.isColorForced) {
            return;
        }
        AEColor[] sideColors = this.getNeighborCableColors();
        AEColor currentColor = this.gridProxy.myColor;
        if (this.attachmentSide != ForgeDirection.UNKNOWN.ordinal() && sideColors[this.attachmentSide] != null) {
            if (sideColors[this.attachmentSide] == currentColor) {
                return;
            }
            this.setProviderColor(sideColors[this.attachmentSide]);
            return;
        }
        for (int index = 0; index < 6; ++index) {
            if (sideColors[index] == null) continue;
            if (sideColors[index] == currentColor) {
                this.attachmentSide = index;
                this.saveChanges();
                return;
            }
            if (currentColor != AEColor.Transparent) continue;
            this.attachmentSide = index;
            this.setProviderColor(sideColors[index]);
            return;
        }
        this.attachmentSide = ForgeDirection.UNKNOWN.ordinal();
        this.setProviderColor(AEColor.Transparent);
    }

    public AECableType getCableConnectionType(ForgeDirection direction) {
        return AECableType.SMART;
    }

    public AEColor getColor() {
        return this.gridProxy.myColor;
    }

    public AEColor getGridColor() {
        return this.gridProxy.getGridColor();
    }

    public boolean isActive() {
        if (EffectiveSide.isServerSide() && this.gridProxy != null && this.gridProxy.getNode() != null) {
            this.isActive = this.gridProxy.getNode().isActive();
        }
        return this.isActive;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void onLoadNBT(NBTTagCompound data) {
        int attachmentSideFromNBT = ForgeDirection.UNKNOWN.ordinal();
        if (data.func_74764_b(NBT_KEY_ISCOLORFORCED)) {
            this.isColorForced = data.func_74767_n(NBT_KEY_ISCOLORFORCED);
        }
        if (data.func_74764_b(NBT_KEY_COLOR)) {
            this.setProviderColor(EnumCache.AE_COLOR[data.func_74762_e(NBT_KEY_COLOR)]);
        }
        if (data.func_74764_b(NBT_KEY_ATTACHMENT)) {
            attachmentSideFromNBT = data.func_74762_e(NBT_KEY_ATTACHMENT);
        }
        this.setupProvider(attachmentSideFromNBT);
    }

    public void onReady() {
        super.onReady();
        this.checkGridConnectionColor();
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    @SideOnly(value=Side.CLIENT)
    public boolean onReceiveNetworkData(ByteBuf data) {
        this.setProviderColor(EnumCache.AE_COLOR[data.readInt()]);
        this.isActive = data.readBoolean();
        return true;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void onSaveNBT(NBTTagCompound data) {
        data.func_74768_a(NBT_KEY_COLOR, this.getGridColor().ordinal());
        data.func_74768_a(NBT_KEY_ATTACHMENT, this.attachmentSide);
        data.func_74757_a(NBT_KEY_ISCOLORFORCED, this.isColorForced);
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onSendNetworkData(ByteBuf data) throws IOException {
        data.writeInt(this.getGridColor().ordinal());
        data.writeBoolean(this.isActive());
    }

    @MENetworkEventSubscribe
    public final void powerEvent(MENetworkPowerStatusChange event) {
        this.markForUpdate();
    }

    public boolean recolourBlock(ForgeDirection side, AEColor color, EntityPlayer player) {
        this.isColorForced = true;
        this.setProviderColor(color);
        return true;
    }

    public void setOwner(EntityPlayer player) {
        this.gridProxy.setOwner(player);
    }

    public void setupProvider(int attachmentSide) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.attachmentSide = attachmentSide;
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.gridProxy.setIdlePowerUsage(this.getIdlePowerusage());
        }
    }
}

