/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities;

import appeng.api.storage.IMEInventory;
import appeng.api.storage.ISaveProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerEssentiaCellWorkbench;
import thaumicenergistics.inventory.HandlerItemEssentiaCell;
import thaumicenergistics.items.ItemEssentiaCell;
import thaumicenergistics.network.packet.client.PacketClientAspectSlot;
import thaumicenergistics.util.EffectiveSide;

public class TileEssentiaCellWorkbench
extends TileEntity
implements IInventory,
ISaveProvider {
    private static String NBT_KEY_CELL = "EssentiaCell";
    private ItemStack eCell = null;
    private HandlerItemEssentiaCell eCellHandler = null;
    private final List<ContainerEssentiaCellWorkbench> openContainers = new ArrayList<ContainerEssentiaCellWorkbench>();

    private void forceContainerSyncCell() {
        for (ContainerEssentiaCellWorkbench container : this.openContainers) {
            container.onForceSyncCell();
        }
    }

    private void onCellChanged() {
        for (ContainerEssentiaCellWorkbench container : this.openContainers) {
            container.onCellChanged();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        ItemStack rtn = null;
        if (this.hasEssentiaCell()) {
            rtn = this.eCell;
            this.func_70299_a(slotIndex, null);
        }
        return rtn;
    }

    public String func_145825_b() {
        return "thaumicenergistics.essentia.cell.workbench.inventory";
    }

    public int func_70297_j_() {
        return 1;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.eCell;
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.eCell;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean hasEssentiaCell() {
        return this.eCell != null;
    }

    public boolean func_94041_b(int slotIndex, ItemStack stack) {
        return stack == null || stack.func_77973_b() instanceof ItemEssentiaCell;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean onClientRequestAddAspectToPartitionList(EntityPlayer player, Aspect aspect) {
        if (this.eCellHandler != null && this.eCellHandler.addAspectToPartitionList(aspect)) {
            this.onClientRequestPartitionList(player);
            return true;
        }
        return false;
    }

    public void onClientRequestClearPartitioning(EntityPlayer player) {
        if (this.eCellHandler != null) {
            this.eCellHandler.clearPartitioning();
            this.onClientRequestPartitionList(player);
            this.forceContainerSyncCell();
        }
    }

    public void onClientRequestPartitionList(EntityPlayer player) {
        List<Aspect> partitionList = this.eCellHandler != null ? this.eCellHandler.getPartitionAspects() : new ArrayList<Aspect>();
        new PacketClientAspectSlot().createFilterListUpdate(partitionList, player).sendPacketToPlayer();
    }

    public void onClientRequestPartitionToContents(EntityPlayer player) {
        if (this.eCellHandler != null) {
            this.eCellHandler.partitionToCellContents();
            this.onClientRequestPartitionList(player);
        }
    }

    public void onClientRequestRemoveAspectFromPartitionList(EntityPlayer player, Aspect aspect) {
        if (this.eCellHandler != null && this.eCellHandler.removeAspectFromPartitionList(aspect)) {
            this.onClientRequestPartitionList(player);
        }
    }

    public void onClientRequestReplaceAspectFromPartitionList(EntityPlayer player, Aspect fromAspect, Aspect toAspect) {
        if (this.eCellHandler != null && this.eCellHandler.replaceAspectInPartitionList(fromAspect, toAspect)) {
            this.onClientRequestPartitionList(player);
        }
    }

    public void func_70295_k_() {
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b(NBT_KEY_CELL)) {
            this.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l(NBT_KEY_CELL)));
        }
    }

    public void registerContainer(ContainerEssentiaCellWorkbench container) {
        if (!this.openContainers.contains((Object)container)) {
            this.openContainers.add(container);
        }
    }

    public void removeContainer(ContainerEssentiaCellWorkbench container) {
        this.openContainers.remove((Object)container);
    }

    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public void func_70299_a(int slotIndex, ItemStack stack) {
        if (this.func_94041_b(slotIndex, stack)) {
            this.eCell = stack;
            if (EffectiveSide.isServerSide()) {
                this.eCellHandler = stack == null ? null : new HandlerItemEssentiaCell(stack, this);
                this.onCellChanged();
            }
        }
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.hasEssentiaCell()) {
            NBTTagCompound cellData = this.eCell.func_77955_b(new NBTTagCompound());
            data.func_74782_a(NBT_KEY_CELL, (NBTBase)cellData);
        }
    }
}

