/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.items;

import appeng.api.AEApi;
import appeng.api.parts.IPartHost;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.parts.PartPlacement;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumicenergistics.network.packet.client.PacketAreaParticleFX;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.util.EffectiveSide;

public class ItemFocusAEWrench
extends ItemFocusBasic {
    private ItemStack psuedoWrench = null;
    private final AspectList castCost = new AspectList();

    public ItemFocusAEWrench() {
        this.castCost.add(Aspect.FIRE, 10);
        this.castCost.add(Aspect.AIR, 10);
    }

    public static boolean isWrenchEnabled() {
        return AEConfig.instance.isFeatureEnabled(AEFeature.QuartzWrench) && AEApi.instance().definitions().items().certusQuartzWrench().maybeItem().isPresent();
    }

    private void activateWrenchLeftClick(World world, int x, int y, int z, EntityPlayer player, int side, ItemStack wandStack) {
        if (world.field_72995_K) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        if (!world.func_72962_a(player, x, y, z)) {
            return;
        }
        if (wandStack == null || !(wandStack.func_77973_b() instanceof ItemWandCasting)) {
            return;
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        if (!wand.consumeAllVis(wandStack, player, this.castCost, false, false)) {
            return;
        }
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            new PacketAreaParticleFX().createWrenchFX(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, x, y, z, Aspect.ENERGY).sendToAllAround(20);
            wand.consumeAllVis(wandStack, player, this.castCost, true, false);
            block.func_149695_a(world, x, y, z, Blocks.field_150350_a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateWrenchRightClick(World world, EntityPlayer player, MovingObjectPosition position, ItemStack wandStack) {
        if (world.field_72995_K) {
            return;
        }
        Block block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        if (wandStack == null || !(wandStack.func_77973_b() instanceof ItemWandCasting)) {
            return;
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        if (!wand.consumeAllVis(wandStack, player, this.castCost, false, false)) {
            return;
        }
        int heldIndex = player.field_71071_by.field_70461_c;
        ItemStack prevHolding = player.field_71071_by.field_70462_a[heldIndex];
        player.field_71071_by.field_70462_a[heldIndex] = this.getWrench();
        try {
            TileEntity tile;
            boolean didWrench = false;
            if (this.getWrench() != null && (tile = world.func_147438_o(position.field_72311_b, position.field_72312_c, position.field_72309_d)) instanceof IPartHost) {
                didWrench = PartPlacement.place((ItemStack)this.getWrench(), (int)position.field_72311_b, (int)position.field_72312_c, (int)position.field_72309_d, (int)position.field_72310_e, (EntityPlayer)player, (World)world, (PartPlacement.PlaceType)PartPlacement.PlaceType.INTERACT_FIRST_PASS, (int)0);
            }
            if (!didWrench) {
                block.func_149727_a(world, position.field_72311_b, position.field_72312_c, position.field_72309_d, player, position.field_72310_e, (float)position.field_72307_f.field_72450_a, (float)position.field_72307_f.field_72448_b, (float)position.field_72307_f.field_72449_c);
                boolean bl = didWrench = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d) == Blocks.field_150350_a;
            }
            if (didWrench) {
                new PacketAreaParticleFX().createWrenchFX(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, position.field_72311_b, position.field_72312_c, position.field_72309_d, Aspect.ENERGY).sendToAllAround(20);
                wand.consumeAllVis(wandStack, player, this.castCost, true, false);
            }
        }
        finally {
            player.field_71071_by.field_70462_a[heldIndex] = prevHolding;
        }
    }

    private ItemStack getWrench() {
        if (this.psuedoWrench == null && ItemFocusAEWrench.isWrenchEnabled()) {
            this.psuedoWrench = (ItemStack)AEApi.instance().definitions().items().certusQuartzWrench().maybeStack(1).orNull();
        }
        return this.psuedoWrench;
    }

    public int getActivationCooldown(ItemStack focusstack) {
        return 250;
    }

    public int getFocusColor(ItemStack itemStack) {
        return Aspect.ENERGY.getColor();
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemStack, int rank) {
        return new FocusUpgradeType[0];
    }

    public String func_77658_a() {
        if (ItemFocusAEWrench.isWrenchEnabled()) {
            return ThEStrings.Item_FocusAEWrench.getUnlocalized();
        }
        return ThEStrings.Item_FocusAEWrench_Disabled.getUnlocalized();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public AspectList getVisCost(ItemStack itemStack) {
        return this.castCost;
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack wandStack) {
        MovingObjectPosition position;
        if (entity instanceof EntityPlayer && entity.func_70093_af() && (position = this.func_77621_a(entity.field_70170_p, (EntityPlayer)entity, false)) != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (EffectiveSide.isServerSide()) {
                this.activateWrenchLeftClick(entity.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d, (EntityPlayer)entity, position.field_72310_e, wandStack);
            }
            return true;
        }
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack wandStack, World world, EntityPlayer player, MovingObjectPosition position) {
        if (player.func_70093_af() && position != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.activateWrenchRightClick(world, player, position, wandStack);
        }
        return wandStack;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("thaumicenergistics:foci.aewrench");
    }
}

