/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.inventory;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumicenergistics.integration.tc.ArcaneCraftingPattern;
import thaumicenergistics.items.ItemKnowledgeCore;

public class HandlerKnowledgeCore {
    private static final String NBTKEY_PATTERNS = "Patterns";
    public static final int MAXIMUM_STORED_PATTERNS = 21;
    private ArrayList<ArcaneCraftingPattern> patterns = new ArrayList(21);
    private ItemStack kCore;

    public HandlerKnowledgeCore(ItemStack kCore) {
        this.kCore = kCore;
        this.loadKCoreData();
    }

    private NBTTagCompound getOrCreateNBT() {
        if (!this.kCore.func_77942_o()) {
            this.kCore.field_77990_d = new NBTTagCompound();
        }
        return this.kCore.field_77990_d;
    }

    private void loadKCoreData() {
        this.patterns.clear();
        NBTTagCompound data = this.getOrCreateNBT();
        if (data.func_74764_b(NBTKEY_PATTERNS)) {
            NBTTagList plist = data.func_150295_c(NBTKEY_PATTERNS, 10);
            for (int index = 0; index < plist.func_74745_c(); ++index) {
                this.patterns.add(new ArcaneCraftingPattern(this.kCore, plist.func_150305_b(index)));
            }
        }
    }

    private void saveKCoreData() {
        NBTTagCompound data = this.getOrCreateNBT();
        NBTTagList plist = new NBTTagList();
        for (ArcaneCraftingPattern pattern : this.patterns) {
            if (pattern == null) continue;
            plist.func_74742_a((NBTBase)pattern.writeToNBT(new NBTTagCompound()));
        }
        if (plist.func_74745_c() > 0) {
            data.func_74782_a(NBTKEY_PATTERNS, (NBTBase)plist);
        }
    }

    public void addPattern(ArcaneCraftingPattern pattern) {
        if (!this.hasRoomToStorePattern()) {
            return;
        }
        ArcaneCraftingPattern existingPattern = this.getPatternForItem(pattern.result.getItemStack());
        if (existingPattern == null) {
            this.patterns.add(pattern);
            this.saveKCoreData();
        }
    }

    public void close() {
        this.kCore = null;
        this.patterns.clear();
    }

    public ArcaneCraftingPattern getPatternForItem(ItemStack resultStack) {
        for (ArcaneCraftingPattern p : this.patterns) {
            if (p == null || p.result == null || !ItemStack.func_77989_b((ItemStack)p.result.getItemStack(), (ItemStack)resultStack)) continue;
            return p;
        }
        return null;
    }

    public ArrayList<ArcaneCraftingPattern> getPatterns() {
        return this.patterns;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ArcaneCraftingPattern p : this.patterns) {
            if (p == null || p.result == null) continue;
            results.add(p.result.getItemStack());
        }
        return results;
    }

    public boolean hasPatternFor(ItemStack resultStack) {
        return this.getPatternForItem(resultStack) != null;
    }

    public boolean hasRoomToStorePattern() {
        return this.patterns.size() < 21;
    }

    public boolean isHandlingCore(ItemStack kCore) {
        if (this.kCore == null) {
            return false;
        }
        if (kCore == null || kCore.func_77973_b() == null) {
            return false;
        }
        if (!(kCore.func_77973_b() instanceof ItemKnowledgeCore)) {
            return false;
        }
        return ItemStack.func_77989_b((ItemStack)kCore, (ItemStack)this.kCore) && ItemStack.func_77970_a((ItemStack)kCore, (ItemStack)this.kCore);
    }

    public void removePattern(ArcaneCraftingPattern pattern) {
        if (this.patterns.remove(pattern)) {
            this.saveKCoreData();
        }
    }
}

