/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.inventory;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.tile.storage.TileIOPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.items.ItemEssentiaCell;
import thaumicenergistics.registries.ItemEnum;

public class HandlerItemEssentiaCell
implements IMEInventoryHandler<IAEFluidStack> {
    private static final String NBT_ESSENTIA_NUMBER_KEY = "Essentia#";
    private static final String NBT_SORT_KEY = "SortMode";
    private static final String NBT_PARTITION_KEY = "Partitions";
    private static final String NBT_PARTITION_COUNT_KEY = "PartitionCount";
    private static final String NBT_PARTITION_NUMBER_KEY = "Partition#";
    private static final long ESSENTIA_PER_BYTE = 2L;
    private NBTTagCompound cellData;
    private AspectStack[] storedEssentia;
    private int totalTypes;
    protected long totalBytes;
    protected long totalEssentiaStorage;
    private long usedEssentiaStorage = 0L;
    private AspectStackComparator.ComparatorMode sortMode;
    private final ISaveProvider saveProvider;
    protected final List<Aspect> partitionAspects = new ArrayList<Aspect>();

    public HandlerItemEssentiaCell(ItemStack storageStack, ISaveProvider saveProvider) {
        if (!storageStack.func_77942_o()) {
            storageStack.func_77982_d(new NBTTagCompound());
        }
        this.cellData = storageStack.func_77978_p();
        this.totalTypes = ((ItemEssentiaCell)ItemEnum.ESSENTIA_CELL.getItem()).maxTypes(storageStack);
        this.totalBytes = ((ItemEssentiaCell)ItemEnum.ESSENTIA_CELL.getItem()).maxStorage(storageStack);
        this.totalEssentiaStorage = this.totalBytes * 2L;
        this.storedEssentia = new AspectStack[this.totalTypes];
        this.saveProvider = saveProvider;
        this.readCellData();
    }

    private long addEssentiaToCell(Aspect aspect, long amount, Actionable mode) {
        long amountToStore = Math.min(amount, this.totalEssentiaStorage - this.usedEssentiaStorage);
        if (amountToStore == 0L) {
            return amount;
        }
        int slotIndex = this.getSlotFor(aspect);
        if (slotIndex == -1) {
            return amount;
        }
        if (mode == Actionable.MODULATE) {
            AspectStack stackToAddTo = this.storedEssentia[slotIndex];
            if (stackToAddTo == null) {
                this.storedEssentia[slotIndex] = stackToAddTo = new AspectStack(aspect, 0L);
            }
            stackToAddTo.amount += amountToStore;
            this.usedEssentiaStorage += amountToStore;
            this.writeStorageChanges(slotIndex, stackToAddTo);
        }
        return amount - amountToStore;
    }

    private long extractEssentiaFromCell(Aspect aspect, long amount, Actionable mode) {
        int slotIndex = this.getSlotFor(aspect);
        if (slotIndex == -1 || this.storedEssentia[slotIndex] == null) {
            return 0L;
        }
        AspectStack slotToExtractFrom = this.storedEssentia[slotIndex];
        long amountToExtract = Math.min(slotToExtractFrom.amount, amount);
        if (mode == Actionable.MODULATE) {
            slotToExtractFrom.amount -= amountToExtract;
            if (slotToExtractFrom.amount == 0L) {
                slotToExtractFrom = null;
                this.storedEssentia[slotIndex] = null;
            }
            this.usedEssentiaStorage -= amountToExtract;
            this.writeStorageChanges(slotIndex, slotToExtractFrom);
        }
        return amountToExtract;
    }

    private int getSlotFor(Aspect aspect) {
        int slot = -1;
        for (int index = 0; index < this.totalTypes; ++index) {
            AspectStack internalStack = this.storedEssentia[index];
            if (internalStack == null) {
                if (slot != -1) continue;
                slot = index;
                continue;
            }
            if (internalStack.aspect != aspect) continue;
            slot = index;
            break;
        }
        return slot;
    }

    private void readCellData() {
        for (int index = 0; index < this.totalTypes; ++index) {
            if (!this.cellData.func_74764_b(NBT_ESSENTIA_NUMBER_KEY + index)) continue;
            this.storedEssentia[index] = AspectStack.loadAspectStackFromNBT(this.cellData.func_74775_l(NBT_ESSENTIA_NUMBER_KEY + index));
            if (this.storedEssentia[index] == null) continue;
            this.usedEssentiaStorage += this.storedEssentia[index].amount;
        }
        this.sortMode = this.cellData.func_74764_b(NBT_SORT_KEY) ? AspectStackComparator.ComparatorMode.VALUES[this.cellData.func_74762_e(NBT_SORT_KEY)] : AspectStackComparator.ComparatorMode.MODE_ALPHABETIC;
        if (this.cellData.func_74764_b(NBT_PARTITION_KEY)) {
            NBTTagCompound partitionData = this.cellData.func_74775_l(NBT_PARTITION_KEY);
            int partitionCount = partitionData.func_74762_e(NBT_PARTITION_COUNT_KEY);
            for (int i = 0; i < partitionCount; ++i) {
                Aspect partitionAspect;
                String tag = partitionData.func_74779_i(NBT_PARTITION_NUMBER_KEY + i);
                if (tag.equals("") || (partitionAspect = (Aspect)Aspect.aspects.get(tag)) == null) continue;
                this.partitionAspects.add(partitionAspect);
            }
        }
    }

    private void writePartitionList() {
        if (!this.isPartitioned()) {
            this.cellData.func_82580_o(NBT_PARTITION_KEY);
        } else {
            NBTTagCompound partitionData = new NBTTagCompound();
            int count = 0;
            for (Aspect pAspect : this.partitionAspects) {
                partitionData.func_74778_a(NBT_PARTITION_NUMBER_KEY + count, pAspect.getTag());
                ++count;
            }
            partitionData.func_74768_a(NBT_PARTITION_COUNT_KEY, count);
            this.cellData.func_74782_a(NBT_PARTITION_KEY, (NBTBase)partitionData);
        }
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((IMEInventory)this);
        }
    }

    private void writeStorageChanges(int slotIndex, AspectStack aspectStack) {
        NBTTagCompound essentiaTag = new NBTTagCompound();
        if (aspectStack != null && aspectStack.aspect != null && aspectStack.amount > 0L) {
            aspectStack.writeToNBT(essentiaTag);
            this.cellData.func_74782_a(NBT_ESSENTIA_NUMBER_KEY + slotIndex, (NBTBase)essentiaTag);
        } else {
            this.cellData.func_82580_o(NBT_ESSENTIA_NUMBER_KEY + slotIndex);
        }
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((IMEInventory)this);
        }
    }

    public boolean addAspectToPartitionList(Aspect aspect) {
        if (!this.partitionAspects.contains(aspect)) {
            this.partitionAspects.add(aspect);
            this.writePartitionList();
            return true;
        }
        return false;
    }

    public boolean canAccept(IAEFluidStack input) {
        Aspect inputAspect;
        if (input == null) {
            return false;
        }
        Fluid inputFluid = input.getFluid();
        if (!(inputFluid instanceof GaseousEssentia)) {
            return false;
        }
        if (this.isPartitioned() && !this.partitionAspects.contains(inputAspect = ((GaseousEssentia)inputFluid).getAspect())) {
            return false;
        }
        return -1 != this.getSlotFor(((GaseousEssentia)inputFluid).getAspect());
    }

    public void clearPartitioning() {
        this.partitionAspects.clear();
        this.writePartitionList();
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null || request.getFluid() == null || !(request.getFluid() instanceof GaseousEssentia)) {
            return null;
        }
        Aspect requestAspect = ((GaseousEssentia)request.getFluid()).getAspect();
        long essentiaAmountRequested = EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(request.getStackSize());
        if (essentiaAmountRequested == 0L) {
            return null;
        }
        long extractedEssentiaAmount = this.extractEssentiaFromCell(requestAspect, essentiaAmountRequested, mode);
        if (extractedEssentiaAmount == 0L) {
            return null;
        }
        IAEFluidStack extractedFluid = request.copy();
        if (!(src instanceof MachineSource) || !(((MachineSource)src).via instanceof TileIOPort)) {
            extractedFluid.setStackSize(EssentiaConversionHelper.instance.convertEssentiaAmountToFluidAmount(extractedEssentiaAmount));
        }
        return extractedFluid;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> availableList) {
        for (AspectStack essentiaStack : this.storedEssentia) {
            if (essentiaStack == null) continue;
            GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(essentiaStack.aspect);
            availableList.add((IAEStack)EssentiaConversionHelper.instance.createAEFluidStackInEssentiaUnits(essentiaGas, essentiaStack.amount));
        }
        return availableList;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public long getFreeBytes() {
        return this.totalBytes - this.getUsedBytes();
    }

    public List<Aspect> getPartitionAspects() {
        return Collections.unmodifiableList(this.partitionAspects);
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public AspectStackComparator.ComparatorMode getSortingMode() {
        return this.sortMode;
    }

    public List<AspectStack> getStoredEssentia() {
        ArrayList<AspectStack> storedList = new ArrayList<AspectStack>(this.totalTypes);
        for (AspectStack stack : this.storedEssentia) {
            if (stack == null) continue;
            storedList.add(stack);
        }
        return storedList;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int getTotalTypes() {
        return this.totalTypes;
    }

    public long getUsedBytes() {
        return (long)Math.ceil((double)this.usedEssentiaStorage / 2.0);
    }

    public int getUsedTypes() {
        int typeCount = 0;
        for (AspectStack stack : this.storedEssentia) {
            if (stack == null) continue;
            ++typeCount;
        }
        return typeCount;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (input == null) {
            return null;
        }
        if (input.getFluid() == null || !(input.getFluid() instanceof GaseousEssentia)) {
            return input.copy();
        }
        Aspect essentiaAspect = ((GaseousEssentia)input.getFluid()).getAspect();
        long amountToStore = EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(input.getStackSize());
        if (amountToStore == 0L) {
            return input.copy();
        }
        long amountNotStored = this.addEssentiaToCell(essentiaAspect, amountToStore, mode);
        if (amountNotStored == 0L) {
            return null;
        }
        IAEFluidStack result = input.copy();
        result.setStackSize(EssentiaConversionHelper.instance.convertEssentiaAmountToFluidAmount(amountNotStored));
        return result;
    }

    public boolean isCreative() {
        return false;
    }

    public boolean isPartitioned() {
        return this.partitionAspects.size() != 0;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        if (this.isPartitioned()) {
            if (input == null) {
                return false;
            }
            Fluid inputFluid = input.getFluid();
            if (!(inputFluid instanceof GaseousEssentia)) {
                return false;
            }
            Aspect inputAspect = ((GaseousEssentia)inputFluid).getAspect();
            return this.partitionAspects.contains(inputAspect);
        }
        return false;
    }

    public void partitionToCellContents() {
        this.partitionAspects.clear();
        for (int slotIndex = 0; slotIndex < this.totalTypes; ++slotIndex) {
            if (this.storedEssentia[slotIndex] == null) continue;
            this.partitionAspects.add(this.storedEssentia[slotIndex].aspect);
        }
        this.writePartitionList();
    }

    public boolean removeAspectFromPartitionList(Aspect aspect) {
        if (this.partitionAspects.remove(aspect)) {
            this.writePartitionList();
            return true;
        }
        return false;
    }

    public boolean replaceAspectInPartitionList(Aspect originalAspect, Aspect newAspect) {
        int index = this.partitionAspects.indexOf(originalAspect);
        if (index >= 0) {
            this.partitionAspects.set(index, newAspect);
            this.writePartitionList();
            return true;
        }
        return false;
    }

    public void setSortingMode(AspectStackComparator.ComparatorMode sortMode) {
        this.cellData.func_74768_a(NBT_SORT_KEY, sortMode.ordinal());
        this.sortMode = sortMode;
    }

    public boolean validForPass(int pass) {
        boolean hasStoredEssentia;
        boolean isPartitioned = this.isPartitioned();
        boolean bl = hasStoredEssentia = this.usedEssentiaStorage > 0L;
        if (pass == 1) {
            return isPartitioned || hasStoredEssentia;
        }
        return !isPartitioned && !hasStoredEssentia;
    }
}

