/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.tc;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;

public final class EssentiaConversionHelper {
    public static final EssentiaConversionHelper instance = new EssentiaConversionHelper();

    private EssentiaConversionHelper() {
    }

    public AspectStack convertAEFluidStackToAspectStack(IAEFluidStack fluidStack) {
        if (fluidStack.getFluid() instanceof GaseousEssentia) {
            return new AspectStack(((GaseousEssentia)fluidStack.getFluid()).getAspect(), this.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize()));
        }
        return null;
    }

    public long convertEssentiaAmountToFluidAmount(long essentiaAmount) {
        return essentiaAmount * (long)ThaumicEnergistics.config.conversionMultiplier();
    }

    public long convertFluidAmountToEssentiaAmount(long fluidAmount) {
        return fluidAmount / (long)ThaumicEnergistics.config.conversionMultiplier();
    }

    public List<AspectStack> convertIIAEFluidStackListToAspectStackList(IItemList<IAEFluidStack> fluidStackList) {
        ArrayList<AspectStack> aspectStackList = new ArrayList<AspectStack>();
        if (fluidStackList != null) {
            for (IAEFluidStack fluidStack : fluidStackList) {
                AspectStack aspectStack = this.convertAEFluidStackToAspectStack(fluidStack);
                if (aspectStack == null) continue;
                aspectStackList.add(aspectStack);
            }
        }
        return aspectStackList;
    }

    public IAEFluidStack createAEFluidStackFromItemEssentiaContainer(ItemStack container) {
        if (container == null) {
            return null;
        }
        if (!EssentiaItemContainerHelper.instance.isContainer(container)) {
            return null;
        }
        Aspect containerAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(container);
        if (containerAspect == null) {
            return null;
        }
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(containerAspect);
        if (essentiaGas == null) {
            return null;
        }
        long containerAmount_EU = EssentiaItemContainerHelper.instance.getContainerStoredAmount(container);
        return this.createAEFluidStackInEssentiaUnits(essentiaGas, containerAmount_EU);
    }

    public IAEFluidStack createAEFluidStackInEssentiaUnits(GaseousEssentia essentiaGas, long essentiaAmount) {
        return this.createAEFluidStackInFluidUnits(essentiaGas, this.convertEssentiaAmountToFluidAmount(essentiaAmount));
    }

    public IAEFluidStack createAEFluidStackInFluidUnits(GaseousEssentia essentiaGas, long fluidAmount) {
        IAEFluidStack ret = AEApi.instance().storage().createFluidStack(new FluidStack((Fluid)essentiaGas, 1));
        ret.setStackSize(fluidAmount);
        return ret;
    }
}

