/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.tc;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ArcaneCraftingPattern
implements ICraftingPatternDetails {
    private static final String NBTKEY_INGREDIENT = "input#";
    private static final String NBTKEY_RESULT = "output";
    private static final int GRID_SIZE = 9;
    public AspectList aspects;
    public IAEItemStack[] ingredients = new IAEItemStack[9];
    public IAEItemStack result;
    public ItemStack knowledgeCoreHost;
    private Aspect[] cachedAspects;

    public ArcaneCraftingPattern(ItemStack knowledgeCore, AspectList aspects, ItemStack craftingResult, ItemStack[] craftingIngredients) {
        this.knowledgeCoreHost = knowledgeCore;
        this.aspects = aspects.copy();
        this.result = AEApi.instance().storage().createItemStack(craftingResult);
        for (int index = 0; index < this.ingredients.length && index < craftingIngredients.length; ++index) {
            ItemStack nextIng = craftingIngredients[index];
            if (nextIng == null) continue;
            this.ingredients[index] = AEApi.instance().storage().createItemStack(nextIng);
        }
    }

    public ArcaneCraftingPattern(ItemStack knowledgeCore, NBTTagCompound data) {
        this.knowledgeCoreHost = knowledgeCore;
        this.aspects = new AspectList();
        this.readFromNBT(data);
    }

    public boolean canSubstitute() {
        return true;
    }

    public Aspect[] getCachedAspects() {
        if (this.cachedAspects == null) {
            this.cachedAspects = this.aspects.getAspects();
        }
        return this.cachedAspects;
    }

    public IAEItemStack[] getCondensedInputs() {
        ArrayList<IAEItemStack> cond = new ArrayList<IAEItemStack>();
        for (int index = 0; index < this.ingredients.length; ++index) {
            if (this.ingredients[index] == null) continue;
            cond.add(this.ingredients[index]);
        }
        return cond.toArray(new IAEItemStack[cond.size()]);
    }

    public IAEItemStack[] getCondensedOutputs() {
        if (this.result == null) {
            return new IAEItemStack[0];
        }
        return new IAEItemStack[]{this.result};
    }

    public IAEItemStack[] getInputs() {
        return this.ingredients;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return this.result.getItemStack();
    }

    public IAEItemStack[] getOutputs() {
        return new IAEItemStack[]{this.result};
    }

    public ItemStack getPattern() {
        return this.knowledgeCoreHost;
    }

    public int getPriority() {
        return 0;
    }

    public boolean isCraftable() {
        return this.result != null;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack repStack, World world) {
        IAEItemStack ingStack = this.ingredients[slotIndex];
        if (ingStack == null || ingStack.getItem() == null || repStack == null || repStack.func_77973_b() == null) {
            return false;
        }
        if (ItemStack.func_77989_b((ItemStack)ingStack.getItemStack(), (ItemStack)repStack)) {
            return true;
        }
        if (OreDictionary.itemMatches((ItemStack)ingStack.getItemStack(), (ItemStack)repStack, (boolean)false)) {
            return true;
        }
        int[] sourceIDs = OreDictionary.getOreIDs((ItemStack)ingStack.getItemStack());
        int[] repIDs = OreDictionary.getOreIDs((ItemStack)repStack);
        for (int i = 0; i < sourceIDs.length; ++i) {
            for (int j = 0; j < repIDs.length; ++j) {
                if (sourceIDs[i] != repIDs[j]) continue;
                return true;
            }
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.aspects.readFromNBT(data);
        for (int index = 0; index < 9; ++index) {
            if (data.func_74764_b(NBTKEY_INGREDIENT + index)) {
                NBTTagCompound ingData = data.func_74775_l(NBTKEY_INGREDIENT + index);
                this.ingredients[index] = AEItemStack.loadItemStackFromNBT((NBTTagCompound)ingData);
                continue;
            }
            this.ingredients[index] = null;
        }
        if (data.func_74764_b(NBTKEY_RESULT)) {
            NBTTagCompound outData = data.func_74775_l(NBTKEY_RESULT);
            this.result = AEItemStack.loadItemStackFromNBT((NBTTagCompound)outData);
        }
    }

    public void setPriority(int priority) {
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        this.aspects.writeToNBT(data);
        for (int index = 0; index < 9; ++index) {
            if (this.ingredients[index] == null) continue;
            NBTTagCompound ingData = new NBTTagCompound();
            this.ingredients[index].writeToNBT(ingData);
            data.func_74782_a(NBTKEY_INGREDIENT + index, (NBTBase)ingData);
        }
        NBTTagCompound outData = new NBTTagCompound();
        this.result.writeToNBT(outData);
        data.func_74782_a(NBTKEY_RESULT, (NBTBase)outData);
        return data;
    }
}

