/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.buttons;

import appeng.api.config.SortOrder;
import appeng.core.localization.ButtonToolTips;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.gui.buttons.AbstractAEButton;
import thaumicenergistics.texture.AEStateIconsEnum;

public class ButtonSortingMode
extends AbstractAEButton {
    private String tooltipSortBy = "";

    public ButtonSortingMode(int ID, int xPosition, int yPosition, int width, int height) {
        super(ID, xPosition, yPosition, width, height, AEStateIconsEnum.SORT_MODE_ALPHABETIC);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        this.addAboutToTooltip(tooltip, ButtonToolTips.SortBy.getLocal(), EnumChatFormatting.GRAY + this.tooltipSortBy);
    }

    public void setSortMode(AspectStackComparator.ComparatorMode mode) {
        switch (mode) {
            case MODE_ALPHABETIC: {
                this.icon = AEStateIconsEnum.SORT_MODE_ALPHABETIC;
                this.tooltipSortBy = ButtonToolTips.ItemName.getLocal();
                break;
            }
            case MODE_AMOUNT: {
                this.icon = AEStateIconsEnum.SORT_MODE_AMOUNT;
                this.tooltipSortBy = ButtonToolTips.NumberOfItems.getLocal();
            }
        }
    }

    public void setSortMode(SortOrder order) {
        switch (order) {
            case AMOUNT: {
                this.icon = AEStateIconsEnum.SORT_MODE_AMOUNT;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.NumberOfItems");
                break;
            }
            case INVTWEAKS: {
                this.icon = AEStateIconsEnum.SORT_MODE_INVTWEAK;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.InventoryTweaks");
                break;
            }
            case MOD: {
                this.icon = AEStateIconsEnum.SORT_MODE_MOD;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.Mod");
                break;
            }
            case NAME: {
                this.icon = AEStateIconsEnum.SORT_MODE_ALPHABETIC;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.ItemName");
            }
        }
    }
}

