/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import appeng.api.parts.IPartHost;
import appeng.helpers.IPriorityHost;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.container.ContainerArcaneAssembler;
import thaumicenergistics.container.ContainerEssentiaCell;
import thaumicenergistics.container.ContainerEssentiaCellWorkbench;
import thaumicenergistics.container.ContainerKnowledgeInscriber;
import thaumicenergistics.container.ContainerPriority;
import thaumicenergistics.container.ContainerWirelessEssentiaTerminal;
import thaumicenergistics.gui.GuiArcaneAssembler;
import thaumicenergistics.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.gui.GuiEssentiaCellWorkbench;
import thaumicenergistics.gui.GuiKnowledgeInscriber;
import thaumicenergistics.gui.GuiPriority;
import thaumicenergistics.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.parts.AbstractAEPartBase;

public class ThEGuiHandler
implements IGuiHandler {
    private static final int DIRECTION_OFFSET = ForgeDirection.values().length;
    public static final int ESSENTIA_CELL_ID = 10;
    private static final int PRIORITY_ID = 20;
    public static final int CELL_WORKBENCH_ID = 30;
    public static final int WIRELESS_TERMINAL_ID = 40;
    public static final int ARCANE_ASSEMBLER_ID = 50;
    public static final int KNOWLEDGE_INSCRIBER = 60;
    private static Object[] extraData = null;

    private static AbstractAEPartBase getPart(ForgeDirection tileSide, World world, int x, int y, int z) {
        IPartHost partHost = (IPartHost)world.func_147438_o(x, y, z);
        if (partHost == null) {
            return null;
        }
        return (AbstractAEPartBase)partHost.getPart(tileSide);
    }

    private static Object getPartGuiElement(ForgeDirection tileSide, EntityPlayer player, World world, int x, int y, int z, boolean isServerSide) {
        AbstractAEPartBase part = ThEGuiHandler.getPart(tileSide, world, x, y, z);
        if (part == null) {
            return null;
        }
        if (isServerSide) {
            return part.getServerGuiElement(player);
        }
        return part.getClientGuiElement(player);
    }

    public static int generatePriorityID(ForgeDirection side) {
        return 20 + side.ordinal();
    }

    public static void launchGui(AbstractAEPartBase part, EntityPlayer player, World world, int x, int y, int z) {
        if (part.doesPlayerHavePermissionToOpenGui(player)) {
            player.openGui((Object)ThaumicEnergistics.instance, part.getSide().ordinal(), world, x, y, z);
        }
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)ThaumicEnergistics.instance, ID + DIRECTION_OFFSET, world, x, y, z);
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z, Object[] extraData) {
        ThEGuiHandler.extraData = extraData;
        player.openGui((Object)ThaumicEnergistics.instance, ID + DIRECTION_OFFSET, world, x, y, z);
        ThEGuiHandler.extraData = null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return ThEGuiHandler.getPartGuiElement(side, player, world, x, y, z, false);
        }
        if ((ID -= DIRECTION_OFFSET) == 10) {
            return GuiEssentiaCellTerminal.NewEssentiaCellGui(player, world, x, y, z);
        }
        if (ID >= 20 && ID < 30) {
            side = ForgeDirection.getOrientation((int)(ID - 20));
            AbstractAEPartBase part = ThEGuiHandler.getPart(side, world, x, y, z);
            if (part == null || !(part instanceof IPriorityHost)) {
                return null;
            }
            return new GuiPriority((IPriorityHost)part, player);
        }
        if (ID == 30) {
            return new GuiEssentiaCellWorkbench(player, world, x, y, z);
        }
        if (ID == 40) {
            return GuiEssentiaCellTerminal.NewWirelessEssentiaTerminalGui(player);
        }
        if (ID == 50) {
            return new GuiArcaneAssembler(player, world, x, y, z);
        }
        if (ID == 60) {
            return new GuiKnowledgeInscriber(player, world, x, y, z);
        }
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return ThEGuiHandler.getPartGuiElement(side, player, world, x, y, z, true);
        }
        if ((ID -= DIRECTION_OFFSET) == 10) {
            return new ContainerEssentiaCell(player, world, x, y, z);
        }
        if (ID >= 20 && ID < 30) {
            side = ForgeDirection.getOrientation((int)(ID - 20));
            AbstractAEPartBase part = ThEGuiHandler.getPart(side, world, x, y, z);
            if (part == null || !(part instanceof IPriorityHost)) {
                return null;
            }
            return new ContainerPriority((IPriorityHost)part, player);
        }
        if (ID == 30) {
            return new ContainerEssentiaCellWorkbench(player, world, x, y, z);
        }
        if (ID == 40) {
            HandlerWirelessEssentiaTerminal handler = (HandlerWirelessEssentiaTerminal)extraData[0];
            return new ContainerWirelessEssentiaTerminal(player, handler);
        }
        if (ID == 50) {
            return new ContainerArcaneAssembler(player, world, x, y, z);
        }
        if (ID == 60) {
            return new ContainerKnowledgeInscriber(player, world, x, y, z);
        }
        return null;
    }
}

