/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.implementations.items.IUpgradeModule;
import appeng.container.slot.SlotInaccessible;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.IVisDiscountGear;
import thaumicenergistics.container.ContainerWithNetworkTool;
import thaumicenergistics.container.slot.SlotRestrictive;
import thaumicenergistics.container.slot.SlotVisDiscountArmor;
import thaumicenergistics.items.ItemKnowledgeCore;
import thaumicenergistics.tileentities.TileArcaneAssembler;
import thaumicenergistics.util.EffectiveSide;

public class ContainerArcaneAssembler
extends ContainerWithNetworkTool {
    private static final int PLAYER_INV_POSITION_Y = 115;
    private static final int HOTBAR_INV_POSITION_Y = 173;
    private static final int PATTERN_SLOT_X = 26;
    private static final int PATTERN_SLOT_Y = 25;
    private static final int PATTERN_ROWS = 3;
    private static final int PATTERN_COLS = 7;
    private static final int KCORE_SLOT_X = 187;
    private static final int KCORE_SLOT_Y = 8;
    private static final int UPGRADE_SLOT_COUNT = 4;
    private static final int UPGRADE_SLOT_X = 187;
    private static final int UPGRADE_SLOT_Y = 26;
    private static final int TARGET_SLOT_X = 14;
    private static final int TARGET_SLOT_Y = 87;
    private static final int DISCOUNT_ARMOR_SLOT_X = 210;
    private static final int DISCOUNT_ARMOR_SLOT_Y = 26;
    private static final int DISCOUNT_ARMOR_COUNT = 4;
    public TileArcaneAssembler assembler;
    private SlotRestrictive kCoreSlot;
    private SlotVisDiscountArmor[] discountSlots = new SlotVisDiscountArmor[4];

    public ContainerArcaneAssembler(EntityPlayer player, World world, int X, int Y, int Z) {
        this.assembler = (TileArcaneAssembler)world.func_147438_o(X, Y, Z);
        IInventory asmInv = this.assembler.getInternalInventory();
        this.bindPlayerInventory((IInventory)player.field_71071_by, 115, 173);
        this.bindToNetworkTool(player.field_71071_by, this.assembler.getLocation(), 0, 35);
        this.kCoreSlot = new SlotRestrictive(asmInv, 0, 187, 8);
        this.func_75146_a(this.kCoreSlot);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 7; ++col) {
                int index = 1 + (row * 7 + col);
                this.func_75146_a((Slot)new SlotInaccessible(asmInv, index, 26 + 18 * col, 25 + 18 * row));
            }
        }
        this.addUpgradeSlots(this.assembler.getUpgradeInventory(), 4, 187, 26);
        this.func_75146_a((Slot)new SlotInaccessible(asmInv, 22, 14, 87));
        for (int index = 0; index < 4; ++index) {
            this.discountSlots[index] = new SlotVisDiscountArmor(asmInv, 23 + index, 210, 26 + index * 18, index);
            this.func_75146_a(this.discountSlots[index]);
        }
    }

    private boolean mergeWithArmorSlots(ItemStack slotStack) {
        for (int index = 0; index < 4; ++index) {
            if (!this.discountSlots[index].func_75214_a(slotStack)) continue;
            this.discountSlots[index].func_75215_d(slotStack.func_77946_l());
            slotStack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (!(slotStack.func_77973_b() instanceof IUpgradeModule)) {
                    if (slotStack.func_77973_b() instanceof ItemKnowledgeCore) {
                        didMerge = this.func_75135_a(slotStack, this.kCoreSlot.field_75222_d, this.kCoreSlot.field_75222_d + 1, false);
                    } else if (slotStack.func_77973_b() instanceof IVisDiscountGear) {
                        didMerge = this.mergeWithArmorSlots(slotStack);
                    }
                    if (!didMerge) {
                        didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                    }
                }
            } else if ((this.kCoreSlot.field_75222_d == slotNumber || slotNumber >= this.discountSlots[0].field_75222_d && slotNumber <= this.discountSlots[3].field_75222_d) && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            }
            if (didMerge) {
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
                return null;
            }
        }
        return super.func_82846_b(player, slotNumber);
    }
}

