/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.blocks.AbstractBlockAEWrenchable;
import thaumicenergistics.registries.BlockEnum;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.tileentities.TileEssentiaVibrationChamber;

public class BlockEssentiaVibrationChamber
extends AbstractBlockAEWrenchable {
    public BlockEssentiaVibrationChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(ThaumicEnergistics.ThETab);
    }

    @Override
    protected boolean onWrenched(World world, int x, int y, int z, int side) {
        TileEntity tileChamber = world.func_147438_o(x, y, z);
        if (!(tileChamber instanceof TileEssentiaVibrationChamber)) {
            return false;
        }
        int sideIndex = ((TileEssentiaVibrationChamber)tileChamber).getForward().ordinal() + 1;
        if (sideIndex >= ForgeDirection.VALID_DIRECTIONS.length) {
            sideIndex = 0;
        }
        ((TileEssentiaVibrationChamber)tileChamber).setOrientation(ForgeDirection.getOrientation((int)sideIndex), ForgeDirection.UP);
        return true;
    }

    public TileEntity func_149915_a(World world, int metaData) {
        return new TileEssentiaVibrationChamber().setupChamberTile();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tileChamber = world.func_147438_o(x, y, z);
        if (!(tileChamber instanceof TileEssentiaVibrationChamber)) {
            return this.func_149691_a(side, 0);
        }
        TileEssentiaVibrationChamber chamber = (TileEssentiaVibrationChamber)tileChamber;
        if (chamber.getForward() != null && side == chamber.getForward().ordinal()) {
            Aspect aspect = chamber.getEssentiaType(null);
            if (aspect == Aspect.ENERGY) {
                return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[3];
            }
            if (aspect == Aspect.FIRE) {
                return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[2];
            }
            return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[1];
        }
        return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 4) {
            return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[1];
        }
        return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[0];
    }

    public String func_149739_a() {
        return BlockEnum.ESSENTIA_VIBRATION_CHAMBER.getUnlocalizedName();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileEntity tileChamber = world.func_147438_o(x, y, z);
        if (tileChamber instanceof TileEssentiaVibrationChamber) {
            if (itemStack.func_77978_p() != null) {
                // empty if block
            }
            if (player instanceof EntityPlayer) {
                ((TileEssentiaVibrationChamber)tileChamber).setOwner((EntityPlayer)player);
            }
            ForgeDirection face = ForgeDirection.NORTH;
            if (player.field_70125_A > 50.0f) {
                face = ForgeDirection.UP;
            } else if (player.field_70125_A < -50.0f) {
                face = ForgeDirection.DOWN;
            } else {
                int sideIndex = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (sideIndex) {
                    case 0: {
                        face = ForgeDirection.NORTH;
                        break;
                    }
                    case 1: {
                        face = ForgeDirection.EAST;
                        break;
                    }
                    case 2: {
                        face = ForgeDirection.SOUTH;
                        break;
                    }
                    case 3: {
                        face = ForgeDirection.WEST;
                    }
                }
            }
            ((TileEssentiaVibrationChamber)tileChamber).setOrientation(face, ForgeDirection.UP);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister register) {
    }
}

