/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.aspect;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.util.GuiHelper;

public class AspectStack {
    public Aspect aspect;
    public long amount;

    public AspectStack() {
        this.aspect = null;
        this.amount = 0L;
    }

    public AspectStack(Aspect aspect, long amount) {
        this.aspect = aspect;
        this.amount = amount;
    }

    public AspectStack(AspectStack source) {
        this.aspect = source.aspect;
        this.amount = source.amount;
    }

    public static AspectStack loadAspectStackFromNBT(NBTTagCompound nbt) {
        Aspect aspect = (Aspect)Aspect.aspects.get(nbt.func_74779_i("AspectTag"));
        if (aspect == null) {
            return null;
        }
        long amount = nbt.func_74763_f("Amount");
        return new AspectStack(aspect, amount);
    }

    public AspectStack copy() {
        return new AspectStack(this);
    }

    public String getAspectName(EntityPlayer player) {
        if (this.aspect == null) {
            return "";
        }
        if (!this.hasPlayerDiscovered(player)) {
            return StatCollector.func_74838_a((String)"tc.aspect.unknown");
        }
        return this.aspect.getName();
    }

    public String getChatColor() {
        if (this.aspect != null) {
            return GuiHelper.instance.getAspectChatColor(this.aspect);
        }
        return "";
    }

    public String getTag() {
        if (this.aspect != null) {
            return this.aspect.getTag();
        }
        return "";
    }

    public boolean hasPlayerDiscovered(EntityPlayer player) {
        boolean hasDiscovered = false;
        if (player != null && this.aspect != null) {
            hasDiscovered = Thaumcraft.proxy.getPlayerKnowledge().hasDiscoveredAspect(player.func_70005_c_(), this.aspect);
        }
        return hasDiscovered;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.aspect != null) {
            nbt.func_74778_a("AspectTag", this.aspect.getTag());
            nbt.func_74772_a("Amount", this.amount);
        }
        return nbt;
    }
}

