/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.compat;

import com.cricketcraft.chisel.carving.Carving;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import net.minecraft.block.Block;

public class Compatibility {
    public static String[] rockColorNames = new String[]{"gray", "lightgray", "brown", "tan", "reddish", "bluish", "greenish"};
    public static Map<Integer, String> tconMap = Maps.newHashMap();

    public static void init(FMLPostInitializationEvent event) {
        Compatibility.addSupport("ProjRed|Exploration", "projectred.exploration.stone", "marble", 0, 99);
        Compatibility.addSupport("ProjRed|Exploration", "projectred.exploration.stone", "marble", 1, 99);
        Compatibility.addSupport("bluepower", "marble", "marble", 0, 99);
        Compatibility.addSupport("Artifice", "artifice.marble", "marble", 0, 99);
        Compatibility.addSupport("Artifice", "artifice.marble.slab", "marble_slab", 0, 99);
        for (String s : rockColorNames) {
            Compatibility.addSupport("Artifice", "artifice.limestone." + s, "limestone", 0, 99);
        }
        Block block = GameRegistry.findBlock((String)"mariculture", (String)"limestone");
        if (block != null) {
            for (int i = 0; i < 16; ++i) {
                Compatibility.addSupport("limestone", block, i, 99);
            }
        }
        Compatibility.addSupport("PFAAGeologica", "strongStone", "marble", 5, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneSlab", "marbleSlab", 5, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneBrickStairs.marble", "marbleStairs", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStone", "limestone", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStoneSlab", "limestoneSlab", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStoneBrickStairs.limestone", "limestoneStairs", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneBrick", "stoneBrick", 3, 99);
        Compatibility.addSupport("PFAAGeologica", "strongCobble", "cobblestone", 3, 99);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            Compatibility.loadThaumcraftAspects();
        }
        for (Integer i : tconMap.keySet()) {
            Compatibility.addSupport("TConstruct", "decoration.multibrick", tconMap.get(i), i, 99);
            Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", tconMap.get(i), i, 99);
        }
        Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", "stonebricksmooth", 14, 99);
        Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", "stonebricksmooth", 15, 99);
        Compatibility.addSupport("Botania", "endStoneBrick", "end_stone", 12, 0);
    }

    public static void addSupport(String modname, String blockname, String name, int metadata, int order) {
        if (Loader.isModLoaded((String)modname) && GameRegistry.findBlock((String)modname, (String)blockname) != null) {
            Compatibility.addSupport(name, GameRegistry.findBlock((String)modname, (String)blockname), metadata, order);
        }
    }

    public static void addSupport(String name, Block block, int metadata, int order) {
        Carving.chisel.addVariation(name, block, metadata, order);
    }

    private static void loadThaumcraftAspects() {
    }

    static {
        tconMap.put(0, "obsidian");
        tconMap.put(1, "sandstone");
        tconMap.put(2, "netherrack");
        tconMap.put(3, "stonebricksmooth");
        tconMap.put(12, "end_stone");
    }
}

