/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerPlaneFormation;
import extracells.gridblock.ECBaseGridBlock;
import extracells.gui.GuiFluidPlaneFormation;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.ColorUtil;
import extracells.util.FluidUtil;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PartFluidPlaneFormation
extends PartECBase
implements IFluidSlotPartOrBlock,
IGridTickable {
    private Fluid fluid;
    private RedstoneMode redstoneMode;
    private ECPrivateInventory upgradeInventory = new ECPrivateInventory("", 1, 1){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return AEApi.instance().materials().materialCardRedstone.sameAsStack(itemStack);
        }
    };

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    public void doWork() {
        int z;
        int y;
        int x;
        TileEntity hostTile = this.getHostTile();
        ECBaseGridBlock gridBlock = this.getGridBlock();
        ForgeDirection side = this.getSide();
        if (this.fluid == null || hostTile == null || gridBlock == null) {
            return;
        }
        IMEMonitor<IAEFluidStack> monitor = gridBlock.getFluidMonitor();
        if (monitor == null) {
            return;
        }
        World world = hostTile.func_145831_w();
        Block worldBlock = world.func_147439_a(x = hostTile.field_145851_c + side.offsetX, y = hostTile.field_145848_d + side.offsetY, z = hostTile.field_145849_e + side.offsetZ);
        if (worldBlock != null && worldBlock != Blocks.field_150350_a) {
            return;
        }
        IAEFluidStack canDrain = (IAEFluidStack)monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.fluid, 1000L), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (canDrain == null || canDrain.getStackSize() < 1000L) {
            return;
        }
        monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.fluid, 1000L), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        Block fluidWorldBlock = this.fluid.getBlock();
        world.func_147449_b(x, y, z, fluidWorldBlock);
        world.func_147471_g(x, y, z);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidPlaneFormation(this, player);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPlaneFormation(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    public ECPrivateInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.fluid = FluidRegistry.getFluid((String)data.func_74779_i("fluid"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon side = TextureManager.PANE_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(3.0f, 3.0f, 14.0f, 13.0f, 13.0f, 16.0f);
        rh.setInvColor(AEColor.Cyan.blackVariant);
        rh.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderer);
        Tessellator.field_78398_a.func_78380_c(0xD000D0);
        rh.setInvColor(ColorUtil.getInvertedInt(AEColor.Cyan.mediumVariant));
        rh.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(ColorUtil.getInvertedInt(AEColor.Cyan.whiteVariant));
        rh.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.PANE_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(3.0f, 3.0f, 14.0f, 13.0f, 13.0f, 16.0f);
        IPartHost host = this.getHost();
        if (host != null) {
            ts.func_78378_d(host.getColor().blackVariant);
            rh.renderFace(x, y, z, TextureManager.PANE_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderer);
            if (this.isActive()) {
                ts.func_78380_c(0xD000D0);
            }
            ts.func_78378_d(ColorUtil.getInvertedInt(host.getColor().mediumVariant));
            rh.renderFace(x, y, z, TextureManager.PANE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
            ts.func_78378_d(ColorUtil.getInvertedInt(host.getColor().whiteVariant));
            rh.renderFace(x, y, z, TextureManager.PANE_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderer);
        }
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    public void sendInformation(EntityPlayer _player) {
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{this.fluid})).sendPacketToPlayer(_player);
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.fluid = _fluid;
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{this.fluid})).sendPacketToPlayer(_player);
        this.saveData();
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.doWork();
        return TickRateModulation.SAME;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74778_a("fluid", this.fluid == null ? "" : this.fluid.getName());
    }
}

