/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget.fluid;

import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.util.FluidUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class WidgetFluidSlot
extends Gui {
    private int id;
    private int posX;
    private int posY;
    private Fluid fluid;
    private static final ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/busiofluid.png");
    private IFluidSlotPartOrBlock part;
    private EntityPlayer player;
    private IConfigurable configurable;
    private byte configOption;

    public WidgetFluidSlot(EntityPlayer _player, IFluidSlotPartOrBlock _part, int _posX, int _posY) {
        this(_player, _part, 0, _posX, _posY, null, 0);
    }

    public WidgetFluidSlot(EntityPlayer _player, IFluidSlotPartOrBlock _part, int _id, int _posX, int _posY) {
        this(_player, _part, _id, _posX, _posY, null, 0);
    }

    public WidgetFluidSlot(EntityPlayer _player, IFluidSlotPartOrBlock _part, int _id, int _posX, int _posY, IConfigurable _configurable, byte _configOption) {
        this.player = _player;
        this.part = _part;
        this.id = _id;
        this.posX = _posX;
        this.posY = _posY;
        this.configurable = _configurable;
        this.configOption = _configOption;
    }

    public boolean canRender() {
        return this.configurable == null || this.configurable.getConfigState() >= this.configOption;
    }

    protected void drawHoveringText(List list, int x, int y, FontRenderer fontrenderer) {
        boolean lighting_enabled = GL11.glIsEnabled((int)2896);
        if (!list.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (Object string : list) {
                String s = (String)string;
                int l = fontrenderer.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (list.size() > 1) {
                k1 += 2 + (list.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                String s1 = (String)list.get(k2);
                fontrenderer.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            if (lighting_enabled) {
                GL11.glEnable((int)2896);
            }
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public void drawTooltip() {
        if (this.canRender()) {
            // empty if block
        }
    }

    public void drawWidget() {
        if (!this.canRender()) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(guiTexture);
        this.func_73729_b(this.posX, this.posY, 79, 39, 18, 18);
        GL11.glEnable((int)2896);
        if (this.fluid == null || this.fluid.getIcon() == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(this.posX + 1, this.posY + 1, this.fluid.getIcon(), 16, 16);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void mouseClicked(ItemStack stack) {
        FluidStack fluidStack = FluidUtil.getFluidFromContainer(stack);
        this.fluid = fluidStack == null ? null : fluidStack.getFluid();
        new PacketFluidSlot(this.part, this.id, this.fluid, this.player).sendPacketToServer();
    }

    public void setFluid(Fluid _fluid) {
        this.fluid = _fluid;
    }

    public static interface IConfigurable {
        public byte getConfigState();
    }
}

