/*
 * Decompiled with CFR 0.152.
 */
package extracells.crafting;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import extracells.api.crafting.IFluidCraftingPatternDetails;
import extracells.registries.ItemEnum;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class CraftingPattern
implements IFluidCraftingPatternDetails,
Comparable<CraftingPattern> {
    protected final ICraftingPatternDetails pattern;
    private IAEFluidStack[] fluidsCondensed = null;
    private IAEFluidStack[] fluids = null;

    public CraftingPattern(ICraftingPatternDetails _pattern) {
        this.pattern = _pattern;
    }

    public boolean canSubstitute() {
        return this.pattern.canSubstitute();
    }

    public int compareInt(int int1, int int2) {
        if (int1 == int2) {
            return 0;
        }
        if (int1 < int2) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(CraftingPattern o) {
        return this.compareInt(o.getPriority(), this.getPriority());
    }

    public boolean equals(Object obj) {
        System.out.println(obj);
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftingPattern other = (CraftingPattern)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    @Override
    public IAEFluidStack[] getCondensedFluidInputs() {
        if (this.fluidsCondensed == null) {
            this.getCondensedInputs();
        }
        return this.fluidsCondensed;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.removeFluidContainers(this.pattern.getCondensedInputs(), true);
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.pattern.getCondensedOutputs();
    }

    @Override
    public IAEFluidStack[] getFluidInputs() {
        if (this.fluids == null) {
            this.getInputs();
        }
        return this.fluids;
    }

    public IAEItemStack[] getInputs() {
        return this.removeFluidContainers(this.pattern.getInputs(), false);
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        IAEItemStack[] input = this.pattern.getInputs();
        for (int i = 0; i < input.length; ++i) {
            IAEItemStack stack = input[i];
            if (stack != null && FluidContainerRegistry.isFilledContainer((ItemStack)stack.getItemStack())) {
                try {
                    craftingInv.func_70299_a(i, input[i].getItemStack());
                }
                catch (Throwable e) {}
                continue;
            }
            if (stack == null || !(stack.getItem() instanceof IFluidContainerItem)) continue;
            try {
                craftingInv.func_70299_a(i, input[i].getItemStack());
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        ItemStack returnStack = this.pattern.getOutput(craftingInv, world);
        for (int i = 0; i < input.length; ++i) {
            IAEItemStack stack = input[i];
            if (stack != null && FluidContainerRegistry.isFilledContainer((ItemStack)stack.getItemStack())) {
                craftingInv.func_70299_a(i, null);
                continue;
            }
            if (stack == null || !(stack.getItem() instanceof IFluidContainerItem)) continue;
            craftingInv.func_70299_a(i, null);
        }
        return returnStack;
    }

    public IAEItemStack[] getOutputs() {
        return this.pattern.getOutputs();
    }

    public ItemStack getPattern() {
        ItemStack p = this.pattern.getPattern();
        if (p == null) {
            return null;
        }
        ItemStack s = new ItemStack(ItemEnum.CRAFTINGPATTERN.getItem());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("item", (NBTBase)p.func_77955_b(new NBTTagCompound()));
        s.func_77982_d(tag);
        return s;
    }

    public int getPriority() {
        return this.pattern.getPriority();
    }

    public boolean isCraftable() {
        return this.pattern.isCraftable();
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        return this.pattern.isValidItemForSlot(slotIndex, itemStack, world);
    }

    /*
     * WARNING - void declaration
     */
    public IAEItemStack[] removeFluidContainers(IAEItemStack[] requirements, boolean isCondenced) {
        IAEItemStack[] returnStack = new IAEItemStack[requirements.length];
        IAEFluidStack[] fluidStacks = new IAEFluidStack[requirements.length];
        int removed = 0;
        int i = 0;
        for (IAEItemStack currentRequirement : requirements) {
            if (currentRequirement != null) {
                void var12_20;
                ItemStack current = currentRequirement.getItemStack();
                current.field_77994_a = 1;
                Object var12_21 = null;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)current)) {
                    FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
                } else if (currentRequirement.getItem() instanceof IFluidContainerItem) {
                    FluidStack fluidStack = ((IFluidContainerItem)currentRequirement.getItem()).getFluid(current);
                }
                if (var12_20 == null) {
                    returnStack[i] = currentRequirement;
                } else {
                    ++removed;
                    fluidStacks[i] = AEApi.instance().storage().createFluidStack(new FluidStack(var12_20.getFluid(), (int)((long)var12_20.amount * currentRequirement.getStackSize())));
                }
            }
            ++i;
        }
        if (isCondenced) {
            int i2 = 0;
            IAEFluidStack[] fluids = new IAEFluidStack[removed];
            for (IAEFluidStack iAEFluidStack : fluidStacks) {
                if (iAEFluidStack == null) continue;
                fluids[i2] = iAEFluidStack;
                ++i2;
            }
            int i3 = 0;
            IAEItemStack[] items = new IAEItemStack[requirements.length - removed];
            for (IAEItemStack item : returnStack) {
                if (item == null) continue;
                items[i3] = item;
                ++i3;
            }
            returnStack = items;
            this.fluidsCondensed = fluids;
        } else {
            this.fluids = fluidStacks;
        }
        return returnStack;
    }

    public void setPriority(int priority) {
        this.pattern.setPriority(priority);
    }
}

