/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import java.util.HashMap;
import java.util.Random;
import net.minecraftforge.common.config.Configuration;
import toast.utilityMobs._UtilityMobs;

public abstract class Properties {
    private static final HashMap<String, Object> map = new HashMap();
    public static final String GENERAL = "_general";

    public static void init(Configuration config) {
        config.load();
        Properties.add(config, GENERAL, "alternate_manuals", false, "If this is true, manual recipes will require a book and quill instead of just a book.");
        Properties.add(config, GENERAL, "creeper_head_rarity", 80, "The rarity for a creeper to drop its head when killed. Setting this to 0 disables skull drops. Drop chance is 1/(rarity - looting).");
        Properties.add(config, GENERAL, "hostile", false, "If this is true, all utility mobs added by this mod will be hostile towards players.");
        Properties.add(config, GENERAL, "wither_conversion", true, "Setting this to false disables the wither skull to skeleton skull recipe.");
        Properties.add(config, GENERAL, "skull_rarity", 60, "The rarity for a skeleton to drop its skull when killed. Setting this to 0 disables skull drops. Drop chance is 1/(rarity - looting).");
        int i = _UtilityMobs.UTILITY_TYPES.length;
        while (i-- > 0) {
            String category = _UtilityMobs.UTILITY_TYPES[i].toLowerCase() + "s";
            Properties.add(config, category, "_all", true, "If false, " + (category == "golems" ? "standard" : _UtilityMobs.UTILITY_TYPES[i].toLowerCase()) + " golems will not be buildable.");
            int j = _UtilityMobs.UTILITY_NAMES[i].length;
            while (j-- > 0) {
                Properties.add(config, category, _UtilityMobs.UTILITY_NAMES[i][j], true);
            }
            config.addCustomCategoryComment(category, "Options to disable the building of specific golems or all golems of this type.");
        }
        config.addCustomCategoryComment(GENERAL, "General and/or miscellaneous options.");
        config.save();
    }

    public static Random random() {
        return _UtilityMobs.random;
    }

    public static void debugException(String message) {
        _UtilityMobs.debugException(message);
    }

    public static void add(Configuration config, String category, String field, String defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getString());
    }

    public static void add(Configuration config, String category, String field, int defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getInt(defaultValue));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getDouble(defaultValue));
    }

    public static Object getProperty(String category, String field) {
        return map.get(category + "@" + field);
    }

    public static String getString(String category, String field) {
        return Properties.getProperty(category, field).toString();
    }

    public static boolean getBoolean(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof Integer) {
            return Properties.random().nextInt(((Number)property).intValue()) == 0;
        }
        if (property instanceof Double) {
            return Properties.random().nextDouble() < ((Number)property).doubleValue();
        }
        Properties.debugException("Tried to get boolean for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return false;
    }

    public static int getInt(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1 : 0;
        }
        Properties.debugException("Tried to get int for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return 0;
    }

    public static double getDouble(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).doubleValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1.0 : 0.0;
        }
        Properties.debugException("Tried to get double for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return 0.0;
    }
}

