/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import toast.utilityMobs.BookHelper;
import toast.utilityMobs.Properties;
import toast.utilityMobs.block.EntityAnvilGolem;
import toast.utilityMobs.block.EntityChestEnderGolem;
import toast.utilityMobs.block.EntityChestGolem;
import toast.utilityMobs.block.EntityChestTrappedGolem;
import toast.utilityMobs.block.EntityContainerGolem;
import toast.utilityMobs.block.EntityFurnaceGolem;
import toast.utilityMobs.block.EntityJukeboxGolem;
import toast.utilityMobs.block.EntityLanternGolem;
import toast.utilityMobs.block.EntityWorkbenchGolem;
import toast.utilityMobs.colossal.EntityArmorColossus;
import toast.utilityMobs.colossal.EntityObsidianColossus;
import toast.utilityMobs.colossal.EntityStoneColossus;
import toast.utilityMobs.event.BlockEvent;
import toast.utilityMobs.golem.EntityArmorGolem;
import toast.utilityMobs.golem.EntityBoundSoul;
import toast.utilityMobs.golem.EntityGildedGolem;
import toast.utilityMobs.golem.EntityMelonGolem;
import toast.utilityMobs.golem.EntityObsidianGolem;
import toast.utilityMobs.golem.EntityScarecrow;
import toast.utilityMobs.golem.EntitySteamGolem;
import toast.utilityMobs.golem.EntityStoneGolem;
import toast.utilityMobs.golem.EntityStoneLargeGolem;
import toast.utilityMobs.golem.EntityUMIronGolem;
import toast.utilityMobs.golem.EntityUMSnowGolem;
import toast.utilityMobs.golem.EntityUtilityGolem;
import toast.utilityMobs.turret.EntityBrickTurret;
import toast.utilityMobs.turret.EntityFireTurret;
import toast.utilityMobs.turret.EntityFireballTurret;
import toast.utilityMobs.turret.EntityGatlingTurret;
import toast.utilityMobs.turret.EntityGhastTurret;
import toast.utilityMobs.turret.EntityKillerTurret;
import toast.utilityMobs.turret.EntityObsidianTurret;
import toast.utilityMobs.turret.EntityShotgunTurret;
import toast.utilityMobs.turret.EntitySniperTurret;
import toast.utilityMobs.turret.EntitySnowTurret;
import toast.utilityMobs.turret.EntityStoneTurret;
import toast.utilityMobs.turret.EntityVolleyTurret;

public class BuildHelper {
    public final HashSet<String> clickingBlock = new HashSet();

    public BuildHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean targetBook = false;
        if (event.face < 0 || event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) != Blocks.field_150462_ai) {
            targetBook = BookHelper.checkBook(event.entityPlayer);
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                new BlockEvent(event.entityPlayer, event.x, event.y, event.z, event.face);
            } else if (targetBook) {
                this.clickingBlock.add(event.entityPlayer.func_70005_c_());
            }
        } else if (targetBook && event.entityPlayer.field_70170_p.field_72995_K && !this.clickingBlock.remove(event.entityPlayer.func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.target instanceof EntityLivingBase && BookHelper.interact(event.entityPlayer, (EntityLivingBase)event.target)) {
            event.setCanceled(true);
        }
    }

    public static boolean place(World world, EntityPlayer player, boolean holdingGolemHead, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150423_aK || block == Blocks.field_150428_aP) {
            return BuildHelper.placeGolem(world, player, x, y, z);
        }
        if (block == Blocks.field_150367_z) {
            return BuildHelper.placeTurret(world, player, x, y, z);
        }
        if (block == Blocks.field_150465_bP) {
            switch (BuildHelper.getSkullType(world, x, y, z)) {
                case 0: {
                    return BuildHelper.placeBlock(world, player, x, y, z);
                }
                case 1: {
                    return BuildHelper.placeHostile(world, player, x, y, z);
                }
                case 4: {
                    return BuildHelper.placeColossal(world, player, x, y, z);
                }
            }
            return false;
        }
        if (holdingGolemHead) {
            return BuildHelper.replaceGolem(world, player, x, y, z);
        }
        return false;
    }

    public static int getSkullType(World world, int x, int y, int z) {
        try {
            return ((TileEntitySkull)world.func_147438_o(x, y, z)).func_145904_a();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static boolean placeGolem(World world, EntityPlayer player, int x, int y, int z) {
        if (!Properties.getBoolean("golems", "_all")) {
            return false;
        }
        Block top = world.func_147439_a(x, y - 1, z);
        Block bottom = world.func_147439_a(x, y - 2, z);
        Block armLX = world.func_147439_a(x - 1, y - 1, z);
        Block armRX = world.func_147439_a(x + 1, y - 1, z);
        Block armLZ = world.func_147439_a(x, y - 1, z - 1);
        Block armRZ = world.func_147439_a(x, y - 1, z + 1);
        String owner = null;
        if (player != null) {
            owner = player.func_70005_c_();
        }
        if (top == Blocks.field_150347_e && bottom == Blocks.field_150347_e) {
            boolean zAxis;
            boolean xAxis = armLX == Blocks.field_150347_e && armRX == Blocks.field_150347_e;
            boolean bl = zAxis = armLZ == Blocks.field_150347_e && armRZ == Blocks.field_150347_e;
            if (!Properties.getBoolean("golems", "StoneLargeGolem")) {
                xAxis = false;
                zAxis = false;
            }
            if (xAxis || zAxis) {
                EntityStoneLargeGolem golem = new EntityStoneLargeGolem(world);
                golem.setOwner(owner);
                BuildHelper.init(golem, world, x, y, z);
                BuildHelper.removeLarge(world, xAxis, x, y, z);
                BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
                return true;
            }
            if (!Properties.getBoolean("golems", "StoneGolem")) {
                return false;
            }
            EntityStoneGolem golem = new EntityStoneGolem(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowshovel", x, y, z);
            return true;
        }
        if ((top == Blocks.field_150460_al || top == Blocks.field_150470_am) && bottom == Blocks.field_150347_e) {
            boolean zAxis;
            if (!Properties.getBoolean("golems", "SteamGolem")) {
                return false;
            }
            boolean xAxis = armLX == Blocks.field_150347_e && armRX == Blocks.field_150347_e;
            boolean bl = zAxis = armLZ == Blocks.field_150347_e && armRZ == Blocks.field_150347_e;
            if (xAxis || zAxis) {
                EntitySteamGolem golem = new EntitySteamGolem(world);
                golem.setOwner(owner);
                BuildHelper.init(golem, world, x, y, z);
                BuildHelper.removeLarge(world, xAxis, x, y, z);
                BuildHelper.particleEffect(world, "largesmoke", x, y, z);
                return true;
            }
            return false;
        }
        if (top == Blocks.field_150339_S && bottom == Blocks.field_150339_S) {
            if (armLX == Blocks.field_150339_S && armRX == Blocks.field_150339_S || armLZ == Blocks.field_150339_S && armRZ == Blocks.field_150339_S) {
                return false;
            }
            if (!Properties.getBoolean("golems", "ArmorGolem")) {
                return false;
            }
            EntityArmorGolem golem = new EntityArmorGolem(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (Properties.getBoolean("golems", "Scarecrow") && top == Blocks.field_150325_L && bottom == Blocks.field_150422_aJ) {
            boolean zAxis;
            boolean xAxis = armLX == Blocks.field_150422_aJ && armRX == Blocks.field_150422_aJ;
            boolean bl = zAxis = armLZ == Blocks.field_150422_aJ && armRZ == Blocks.field_150422_aJ;
            if (xAxis || zAxis) {
                EntityScarecrow golem = new EntityScarecrow(world);
                golem.setOwner(owner);
                BuildHelper.init(golem, world, x, y, z);
                BuildHelper.removeLarge(world, xAxis, x, y, z);
                BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
                return true;
            }
            return false;
        }
        if (top == Blocks.field_150340_R && bottom == Blocks.field_150340_R) {
            if (!Properties.getBoolean("golems", "GildedGolem")) {
                return false;
            }
            EntityGildedGolem golem = new EntityGildedGolem(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "critical", x, y, z);
            return true;
        }
        if (top == Blocks.field_150440_ba && bottom == Blocks.field_150440_ba) {
            if (!Properties.getBoolean("golems", "MelonGolem")) {
                return false;
            }
            EntityMelonGolem golem = new EntityMelonGolem(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (top == Blocks.field_150425_aM && bottom == Blocks.field_150425_aM) {
            if (!Properties.getBoolean("golems", "BoundSoul")) {
                return false;
            }
            EntityBoundSoul golem = new EntityBoundSoul(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "magicCrit", x, y, z);
            return true;
        }
        if (top == Blocks.field_150343_Z && bottom == Blocks.field_150343_Z) {
            boolean zAxis;
            if (!Properties.getBoolean("golems", "ObsidianGolem")) {
                return false;
            }
            boolean xAxis = armLX == Blocks.field_150343_Z && armRX == Blocks.field_150343_Z;
            boolean bl = zAxis = armLZ == Blocks.field_150343_Z && armRZ == Blocks.field_150343_Z;
            if (xAxis || zAxis) {
                EntityObsidianGolem golem = new EntityObsidianGolem(world);
                golem.setOwner(owner);
                BuildHelper.init(golem, world, x, y, z);
                BuildHelper.removeLarge(world, xAxis, x, y, z);
                BuildHelper.particleEffect(world, "magicCrit", x, y, z);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean placeTurret(World world, EntityPlayer player, int x, int y, int z) {
        if (!Properties.getBoolean("turrets", "_all")) {
            return false;
        }
        Block top = world.func_147439_a(x, y - 1, z);
        if (top != Blocks.field_150422_aJ && top != Blocks.field_150386_bk) {
            return false;
        }
        Block bottom = world.func_147439_a(x, y - 2, z);
        String owner = null;
        if (player != null) {
            owner = player.func_70005_c_();
        }
        if (bottom == Blocks.field_150347_e) {
            if (!Properties.getBoolean("turrets", "StoneTurret")) {
                return false;
            }
            EntityStoneTurret golem = new EntityStoneTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150433_aE) {
            if (!Properties.getBoolean("turrets", "SnowTurret")) {
                return false;
            }
            EntitySnowTurret golem = new EntitySnowTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150417_aV) {
            if (!Properties.getBoolean("turrets", "BrickTurret")) {
                return false;
            }
            EntityBrickTurret golem = new EntityBrickTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150340_R) {
            if (!Properties.getBoolean("turrets", "GatlingTurret")) {
                return false;
            }
            EntityGatlingTurret golem = new EntityGatlingTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150339_S) {
            if (!Properties.getBoolean("turrets", "ShotgunTurret")) {
                return false;
            }
            EntityShotgunTurret golem = new EntityShotgunTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150368_y) {
            if (!Properties.getBoolean("turrets", "SniperTurret")) {
                return false;
            }
            EntitySniperTurret golem = new EntitySniperTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150451_bX) {
            if (!Properties.getBoolean("turrets", "FireTurret")) {
                return false;
            }
            EntityFireTurret golem = new EntityFireTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150424_aL) {
            if (!Properties.getBoolean("turrets", "FireballTurret")) {
                return false;
            }
            EntityFireballTurret golem = new EntityFireballTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (top == Blocks.field_150386_bk && bottom == Blocks.field_150385_bj) {
            if (!Properties.getBoolean("turrets", "GhastTurret")) {
                return false;
            }
            EntityGhastTurret golem = new EntityGhastTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150475_bE) {
            if (!Properties.getBoolean("turrets", "VolleyTurret")) {
                return false;
            }
            EntityVolleyTurret golem = new EntityVolleyTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (bottom == Blocks.field_150484_ah) {
            if (!Properties.getBoolean("turrets", "KillerTurret")) {
                return false;
            }
            EntityKillerTurret golem = new EntityKillerTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (top == Blocks.field_150386_bk && bottom == Blocks.field_150343_Z) {
            if (!Properties.getBoolean("turrets", "ObsidianTurret")) {
                return false;
            }
            EntityObsidianTurret golem = new EntityObsidianTurret(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x, y, z);
            BuildHelper.removeStandard(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        return false;
    }

    public static boolean placeBlock(World world, EntityPlayer player, int x, int y, int z) {
        if (!Properties.getBoolean("blocks", "_all")) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        String owner = null;
        if (player != null) {
            owner = player.func_70005_c_();
        }
        if (block == Blocks.field_150462_ai) {
            if (!Properties.getBoolean("blocks", "WorkbenchGolem")) {
                return false;
            }
            EntityWorkbenchGolem golem = new EntityWorkbenchGolem(world);
            golem.setOwner(owner);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150428_aP) {
            if (!Properties.getBoolean("blocks", "LanternGolem")) {
                return false;
            }
            EntityLanternGolem golem = new EntityLanternGolem(world);
            golem.setOwner(owner);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150486_ae) {
            if (!Properties.getBoolean("blocks", "ChestGolem")) {
                return false;
            }
            EntityChestGolem golem = new EntityChestGolem(world);
            golem.setOwner(owner);
            BuildHelper.getContents(world, golem, x, y - 1, z);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150447_bR) {
            if (!Properties.getBoolean("blocks", "ChestTrappedGolem")) {
                return false;
            }
            EntityChestTrappedGolem golem = new EntityChestTrappedGolem(world);
            golem.setOwner(owner);
            BuildHelper.getContents(world, golem, x, y - 1, z);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150477_bB) {
            if (!Properties.getBoolean("blocks", "ChestEnderGolem")) {
                return false;
            }
            EntityChestEnderGolem golem = new EntityChestEnderGolem(world);
            golem.setOwner(owner);
            BuildHelper.getContents(world, golem, x, y - 1, z);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150460_al || block == Blocks.field_150470_am) {
            if (!Properties.getBoolean("blocks", "FurnaceGolem")) {
                return false;
            }
            EntityFurnaceGolem golem = new EntityFurnaceGolem(world);
            golem.setOwner(owner);
            BuildHelper.getContents(world, golem, x, y - 1, z);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150467_bQ) {
            if (!Properties.getBoolean("blocks", "AnvilGolem")) {
                return false;
            }
            int damage = Blocks.field_150467_bQ.func_149692_a(world.func_72805_g(x, y - 1, z));
            EntityAnvilGolem golem = new EntityAnvilGolem(world);
            golem.setOwner(owner);
            golem.setDamage(damage);
            BuildHelper.getContents(world, golem, x, y - 1, z);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        if (block == Blocks.field_150421_aI) {
            if (!Properties.getBoolean("blocks", "JukeboxGolem")) {
                return false;
            }
            EntityJukeboxGolem golem = new EntityJukeboxGolem(world);
            golem.setOwner(owner);
            golem.sitAI.sit = true;
            BuildHelper.init(golem, world, x, y + 1, z);
            BuildHelper.removeShort(world, x, y, z);
            BuildHelper.particleEffect(world, "snowballpoof", x, y, z);
            return true;
        }
        return false;
    }

    public static boolean placeHostile(World world, EntityPlayer player, int x, int y, int z) {
        if (!Properties.getBoolean("hostiles", "_all")) {
            return false;
        }
        Block top = world.func_147439_a(x, y - 1, z);
        Block bottom = world.func_147439_a(x, y - 2, z);
        String owner = null;
        if (player != null) {
            owner = player.func_70005_c_();
        }
        return false;
    }

    public static boolean placeColossal(World world, EntityPlayer player, int x, int y, int z) {
        int direction;
        if (!Properties.getBoolean("colossals", "_all")) {
            return false;
        }
        int[] xOff = new int[]{-1, 1, 0, 0};
        int[] zOff = new int[]{0, 0, -1, 1};
        String owner = null;
        if (player != null) {
            owner = player.func_70005_c_();
        }
        if ((direction = BuildHelper.checkColossal(world, Blocks.field_150347_e, x, y, z)) >= 0) {
            if (!Properties.getBoolean("colossals", "StoneColossus")) {
                return false;
            }
            EntityStoneColossus golem = new EntityStoneColossus(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x + xOff[direction], y - 1, z + zOff[direction]);
            BuildHelper.removeColossal(world, direction, x, y, z);
            BuildHelper.particleEffect(world, "critical", x, y, z);
            return true;
        }
        direction = BuildHelper.checkColossal(world, Blocks.field_150343_Z, x, y, z);
        if (direction >= 0) {
            if (!Properties.getBoolean("colossals", "ObsidianColossus")) {
                return false;
            }
            EntityObsidianColossus golem = new EntityObsidianColossus(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x + xOff[direction], y - 1, z + zOff[direction]);
            BuildHelper.removeColossal(world, direction, x, y, z);
            BuildHelper.particleEffect(world, "critical", x, y, z);
            return true;
        }
        direction = BuildHelper.checkColossal(world, Blocks.field_150339_S, x, y, z);
        if (direction >= 0) {
            if (!Properties.getBoolean("colossals", "ArmorColossus")) {
                return false;
            }
            EntityArmorColossus golem = new EntityArmorColossus(world);
            golem.setOwner(owner);
            BuildHelper.init(golem, world, x + xOff[direction], y - 1, z + zOff[direction]);
            BuildHelper.removeColossal(world, direction, x, y, z);
            BuildHelper.particleEffect(world, "critical", x, y, z);
            return true;
        }
        return false;
    }

    public static boolean replaceGolem(World world, EntityPlayer player, int x, int y, int z) {
        if (!Properties.getBoolean("golems", "_all")) {
            return false;
        }
        String owner = null;
        if (player != null) {
            owner = player.func_70005_c_();
        }
        for (Object entity : new ArrayList(world.field_72996_f)) {
            if (!(entity instanceof EntityGolem)) continue;
            EntityGolem golem = (EntityGolem)entity;
            if (golem.field_70163_u != (double)y - 1.95 || golem.field_70165_t != (double)x + 0.5 || golem.field_70161_v != (double)z + 0.5) continue;
            if (golem instanceof EntityIronGolem && ((EntityIronGolem)golem).func_70850_q()) {
                if (!Properties.getBoolean("golems", "UMIronGolem")) {
                    return false;
                }
                EntityUMIronGolem newGolem = new EntityUMIronGolem(world);
                newGolem.setOwner(owner);
                BuildHelper.init(newGolem, world, x, y, z);
                golem.func_70106_y();
                return true;
            }
            if (!(golem instanceof EntitySnowman)) continue;
            if (!Properties.getBoolean("golems", "UMSnowGolem")) {
                return false;
            }
            EntityUMSnowGolem newGolem = new EntityUMSnowGolem(world);
            newGolem.setOwner(owner);
            BuildHelper.init(newGolem, world, x, y, z);
            golem.func_70106_y();
            return true;
        }
        return false;
    }

    public static void init(EntityUtilityGolem golem, World world, int x, int y, int z) {
        golem.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
        golem.func_110161_a(null);
        world.func_72838_d((Entity)golem);
    }

    public static int checkColossal(World world, Block block, int x, int y, int z) {
        boolean failedXn = false;
        boolean failedXp = false;
        boolean failedZn = false;
        boolean failedZp = false;
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j >= -3; --j) {
                if (j < -1 && (i == -2 || i == 2) || j == -3 && i == 0) continue;
                if (!failedXn && world.func_147439_a(x - 1, y + j, z + i) != block) {
                    failedXn = true;
                }
                if (!failedXp && world.func_147439_a(x + 1, y + j, z + i) != block) {
                    failedXp = true;
                }
                if (!failedZn && world.func_147439_a(x + i, y + j, z - 1) != block) {
                    failedZn = true;
                }
                if (failedZp || world.func_147439_a(x + i, y + j, z + 1) == block) continue;
                failedZp = true;
            }
        }
        if (!failedXn) {
            return 0;
        }
        if (!failedXp) {
            return 1;
        }
        if (!failedZn) {
            return 2;
        }
        if (!failedZp) {
            return 3;
        }
        return -1;
    }

    public static void removeColossal(World world, int direction, int x, int y, int z) {
        BuildHelper.removeBlock(world, x, y, z);
        for (int i = -2; i <= 2; ++i) {
            block7: for (int j = 0; j >= -3; --j) {
                if (j < -1 && (i == -2 || i == 2) || j == -3 && i == 0) continue;
                switch (direction) {
                    case 0: {
                        BuildHelper.removeBlock(world, x - 1, y + j, z + i);
                        continue block7;
                    }
                    case 1: {
                        BuildHelper.removeBlock(world, x + 1, y + j, z + i);
                        continue block7;
                    }
                    case 2: {
                        BuildHelper.removeBlock(world, x + i, y + j, z - 1);
                        continue block7;
                    }
                    case 3: {
                        BuildHelper.removeBlock(world, x + i, y + j, z + 1);
                    }
                }
            }
        }
    }

    public static void removeBlock(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
    }

    public static void removeShort(World world, int x, int y, int z) {
        BuildHelper.removeBlock(world, x, y, z);
        BuildHelper.removeBlock(world, x, y - 1, z);
    }

    public static void removeStandard(World world, int x, int y, int z) {
        BuildHelper.removeBlock(world, x, y, z);
        BuildHelper.removeBlock(world, x, y - 1, z);
        BuildHelper.removeBlock(world, x, y - 2, z);
    }

    public static void removeLarge(World world, boolean xAxis, int x, int y, int z) {
        BuildHelper.removeStandard(world, x, y, z);
        if (xAxis) {
            BuildHelper.removeBlock(world, x - 1, y - 1, z);
            BuildHelper.removeBlock(world, x + 1, y - 1, z);
        } else {
            BuildHelper.removeBlock(world, x, y - 1, z - 1);
            BuildHelper.removeBlock(world, x, y - 1, z + 1);
        }
    }

    public static void getContents(World world, EntityContainerGolem golem, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tileEntity.func_145841_b(tag);
            golem.takeContentsFromNBT(tag);
            tileEntity.func_145839_a(tag);
        }
    }

    public static void particleEffect(World world, String particle, int x, int y, int z) {
        int i = 120;
        while (i-- > 0) {
            world.func_72869_a(particle, (double)x + world.field_73012_v.nextDouble(), (double)(y - 2) + world.field_73012_v.nextDouble() * 2.5, (double)z + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

