/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IActivateAwareTile;
import openmods.api.IHasGui;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableItemStack;
import openmods.tileentity.SyncedTileEntity;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.selector.ContainerSelector;
import openperipheral.addons.selector.GuiSelector;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.peripheral.PeripheralTypeId;
import org.apache.commons.lang3.ArrayUtils;

@PeripheralTypeId(value="openperipheral_selector")
public class TileEntitySelector
extends SyncedTileEntity
implements IActivateAwareTile,
IAttachable,
IHasGui {
    private static final List<ItemSlot> BOXES_0 = ImmutableList.of();
    private static final List<ItemSlot> BOXES_1 = ImmutableList.of((Object)new ItemSlot(0, 0.2, 0.5, 0.5));
    private static final double PADDING_2 = 0.05;
    private static final double SIZE_2 = 0.12;
    private static final double DELTA_2 = 0.16999999999999998;
    private static final ImmutableList<ItemSlot> BOXES_2 = ImmutableList.of((Object)new ItemSlot(0, 0.12, 0.33, 0.6699999999999999), (Object)new ItemSlot(1, 0.12, 0.6699999999999999, 0.6699999999999999), (Object)new ItemSlot(3, 0.12, 0.33, 0.33), (Object)new ItemSlot(4, 0.12, 0.6699999999999999, 0.33));
    private static final double SIZE_3 = 0.085;
    private static final double PADDING_3 = 0.08;
    private static final double DELTA_3 = 0.25;
    private static final List<ItemSlot> BOXES_3 = ImmutableList.of((Object)new ItemSlot(0, 0.085, 0.25, 0.75), (Object)new ItemSlot(1, 0.085, 0.5, 0.75), (Object)new ItemSlot(2, 0.085, 0.75, 0.75), (Object)new ItemSlot(3, 0.085, 0.25, 0.5), (Object)new ItemSlot(4, 0.085, 0.5, 0.5), (Object)new ItemSlot(5, 0.085, 0.75, 0.5), (Object)new ItemSlot(6, 0.085, 0.25, 0.25), (Object)new ItemSlot(7, 0.085, 0.5, 0.25), (Object)new ItemSlot(8, 0.085, 0.75, 0.25));
    private Set<IArchitectureAccess> computers = Sets.newIdentityHashSet();
    private final SyncableItemStack[] slots = new SyncableItemStack[9];
    private SoftReference<EntityItem> displayEntity = new SoftReference<Object>(null);
    private int gridSize;

    public TileEntitySelector() {
        for (int i = 0; i < 9; ++i) {
            SyncableItemStack item = new SyncableItemStack();
            this.syncMap.put("Stack" + i, (ISyncableObject)item);
            this.slots[i] = item;
        }
        ISyncListener listener = new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                TileEntitySelector.this.gridSize = TileEntitySelector.this.calculateGridSize();
            }
        };
        this.syncMap.addUpdateListener(listener);
        this.syncMap.addSyncListener(listener);
    }

    protected void createSyncedFields() {
    }

    private boolean hasStack(int slot) {
        return this.slots[slot].get() != null;
    }

    public int calculateGridSize() {
        if (this.hasStack(2) || this.hasStack(5) || this.hasStack(6) || this.hasStack(7) || this.hasStack(8)) {
            return 3;
        }
        if (this.hasStack(1) || this.hasStack(3) || this.hasStack(4)) {
            return 2;
        }
        if (this.hasStack(0)) {
            return 1;
        }
        return 0;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return true;
        }
        Vec3 vec = Vec3.func_72443_a((double)((float)this.field_145851_c + hitX), (double)((float)this.field_145848_d + hitY), (double)((float)this.field_145849_e + hitZ));
        ItemSlot slot = this.getClickedSlot(vec, side);
        if (slot == null) {
            this.openGui(OpenPeripheralAddons.instance, player);
        } else if (this.hasStack(slot.slot)) {
            this.fireEvent("slot_click", slot.slot + 1);
        }
        return true;
    }

    public ItemStack getSlot(int slot) {
        return this.slots[slot].get();
    }

    @Asynchronous
    @ScriptCallable(description="Get the item currently being displayed in a specific slot", returnTypes={ReturnType.TABLE}, name="getSlot")
    public ItemStack getSlotOneBased(@Arg(name="slot", description="The slot you want to get details about") int slot) {
        Preconditions.checkArgument((slot >= 1 && slot <= 9 ? 1 : 0) != 0, (Object)"slot must be between 1 and 9");
        return this.slots[slot - 1].get();
    }

    @Asynchronous
    @ScriptCallable(description="Gets all slots", returnTypes={ReturnType.TABLE})
    public List<ItemStack> getSlots() {
        ArrayList result = Lists.newArrayList();
        for (SyncableItemStack slot : this.slots) {
            result.add(slot.get());
        }
        return result;
    }

    @ScriptCallable(description="Set the items being displayed in all slots")
    public void setSlots(@Arg(name="items", description="A table containing itemstacks", type=ArgType.TABLE) Map<Integer, ItemStack> stacks) {
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack value = stacks.get(slot + 1);
            if (value != null) {
                value.field_77994_a = 1;
            }
            this.slots[slot].set(value);
        }
        this.sync();
    }

    @ScriptCallable(description="Set the item being displayed on a specific slot")
    public void setSlot(@Arg(name="slot", description="The slot you want to modify") int slot, @Optionals @Arg(name="item", description="The item you want to display. nil to set empty.", type=ArgType.TABLE) ItemStack stack) {
        Preconditions.checkArgument((slot >= 1 && slot <= 9 ? 1 : 0) != 0, (Object)"slot must be between 1 and 9");
        --slot;
        if (stack != null) {
            stack.field_77994_a = 1;
        }
        this.slots[slot].set(stack);
        this.sync();
    }

    private void fireEvent(String eventName, Object ... args) {
        for (IArchitectureAccess computer : this.computers) {
            Object[] extendedArgs = ArrayUtils.add((Object[])args, (Object)computer.peripheralName());
            computer.signal(eventName, extendedArgs);
        }
    }

    public void addComputer(IArchitectureAccess computer) {
        this.computers.add(computer);
    }

    public void removeComputer(IArchitectureAccess computer) {
        this.computers.remove(computer);
    }

    public boolean canOpenGui(EntityPlayer player) {
        return false;
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiSelector(new ContainerSelector((IInventory)player.field_71071_by, this));
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerSelector((IInventory)player.field_71071_by, this);
    }

    public IInventory createInventoryWrapper() {
        return new IInventory(){

            public void func_70299_a(int slot, ItemStack stack) {
                TileEntitySelector.this.slots[slot].set(stack);
            }

            public void func_70295_k_() {
            }

            public void func_70296_d() {
                if (!((TileEntitySelector)TileEntitySelector.this).field_145850_b.field_72995_K) {
                    TileEntitySelector.this.sync();
                }
            }

            public boolean func_70300_a(EntityPlayer player) {
                return TileEntitySelector.this.func_145831_w().func_147438_o(TileEntitySelector.this.field_145851_c, TileEntitySelector.this.field_145848_d, TileEntitySelector.this.field_145849_e) == TileEntitySelector.this && player.func_70092_e((double)TileEntitySelector.this.field_145851_c + 0.5, (double)TileEntitySelector.this.field_145848_d + 0.5, (double)TileEntitySelector.this.field_145849_e + 0.5) <= 64.0;
            }

            public boolean func_94041_b(int slot, ItemStack stack) {
                return true;
            }

            public boolean func_145818_k_() {
                return false;
            }

            public ItemStack func_70304_b(int slot) {
                return null;
            }

            public ItemStack func_70301_a(int slot) {
                return TileEntitySelector.this.slots[slot].get();
            }

            public int func_70302_i_() {
                return 9;
            }

            public int func_70297_j_() {
                return 1;
            }

            public String func_145825_b() {
                return "selector";
            }

            public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
                throw new UnsupportedOperationException();
            }

            public void func_70305_f() {
            }
        };
    }

    public AxisAlignedBB getSelection(Vec3 hitVec, int side) {
        ForgeDirection rotation = this.getRotation();
        if (side == rotation.ordinal()) {
            int gridSize = this.getGridSize();
            for (ItemSlot center : this.getSlots(gridSize)) {
                AxisAlignedBB aabb = center.createBox(this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation);
                if (!aabb.func_72318_a(hitVec)) continue;
                return aabb;
            }
        }
        return null;
    }

    private ItemSlot getClickedSlot(Vec3 hitVec, int side) {
        ForgeDirection rotation = this.getRotation();
        if (side == rotation.ordinal()) {
            int gridSize = this.getGridSize();
            for (ItemSlot center : this.getSlots(gridSize)) {
                AxisAlignedBB aabb = center.createBox(this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation);
                if (!aabb.func_72318_a(hitVec)) continue;
                return center;
            }
        }
        return null;
    }

    public List<ItemSlot> getSlots(int gridSize) {
        switch (gridSize) {
            case 1: {
                return BOXES_1;
            }
            case 2: {
                return BOXES_2;
            }
            case 3: {
                return BOXES_3;
            }
        }
        return BOXES_0;
    }

    public EntityItem getDisplayEntity() {
        EntityItem result = this.displayEntity.get();
        if (result == null) {
            result = new EntityItem(this.func_145831_w(), 0.0, 0.0, 0.0);
            result.field_70290_d = 0.0f;
            this.displayEntity = new SoftReference<EntityItem>(result);
        }
        return result;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.gridSize = this.calculateGridSize();
    }

    public static class ItemSlot {
        public final int slot;
        public final double size;
        public final double x;
        public final double y;

        public ItemSlot(int absSlot, double size, double x, double y) {
            this.slot = absSlot;
            this.size = size;
            this.x = x;
            this.y = y;
        }

        private AxisAlignedBB createCenteredBox(double x, double y, double z) {
            return AxisAlignedBB.func_72330_a((double)(x - this.size), (double)(y - this.size), (double)(z - this.size), (double)(x + this.size), (double)(y + this.size), (double)(z + this.size));
        }

        public AxisAlignedBB createBox(int originX, int originY, int originZ, ForgeDirection orientation) {
            switch (orientation) {
                default: {
                    return this.createCenteredBox((double)originX + (1.0 - this.x), (double)originY + this.y, originZ);
                }
                case SOUTH: {
                    return this.createCenteredBox((double)originX + this.x, (double)originY + this.y, originZ + 1);
                }
                case WEST: {
                    return this.createCenteredBox(originX, (double)originY + this.y, (double)originZ + this.x);
                }
                case EAST: {
                    return this.createCenteredBox(originX + 1, (double)originY + this.y, (double)originZ + (1.0 - this.x));
                }
                case UP: {
                    return this.createCenteredBox((double)originX + this.x, originY + 1, (double)originZ + (1.0 - this.y));
                }
                case DOWN: 
            }
            return this.createCenteredBox((double)originX + this.x, originY, (double)originZ + this.y);
        }
    }
}

