/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.base.Strings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.CallbackProperty;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_text")
public class Text
extends Drawable {
    @CallbackProperty
    public String text;
    @CallbackProperty
    public int color;
    @CallbackProperty
    public float alpha = 1.0f;
    @CallbackProperty
    public float scale = 1.0f;
    private int width;
    private int height;

    Text() {
    }

    public Text(short x, short y, String text, int color) {
        super(x, y);
        this.text = text;
        this.color = color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(float partialTicks) {
        GL11.glEnable((int)3553);
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        fontRenderer.func_78276_b(this.text, 0, 0, (int)(this.alpha * 255.0f) << 24 | this.color);
        GL11.glDisable((int)3553);
    }

    @Override
    public Drawable.Type getTypeEnum() {
        return Drawable.Type.TEXT;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.alpha > 0.0f;
    }

    @Override
    protected void onUpdate() {
        this.height = Math.round(8.0f * this.scale);
        if (Strings.isNullOrEmpty((String)this.text)) {
            this.width = 0;
        } else {
            FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
            this.width = Math.round((float)fontRenderer.func_78256_a(this.text) * this.scale);
        }
    }
}

