/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.base.Strings;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.CallbackProperty;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_icon")
public class ItemIcon
extends Drawable {
    @SideOnly(value=Side.CLIENT)
    private RenderItem renderItem;
    private ItemStack drawStack;
    @CallbackProperty
    public float scale = 1.0f;
    @CallbackProperty
    public String itemId;
    @CallbackProperty
    public int meta;

    ItemIcon() {
    }

    public ItemIcon(short x, short y, String itemId, int meta) {
        super(x, y);
        this.itemId = itemId;
        this.meta = meta;
    }

    @SideOnly(value=Side.CLIENT)
    private RenderItem getRenderItem() {
        if (this.renderItem == null) {
            this.renderItem = new RenderItem();
        }
        return this.renderItem;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(float partialTicks) {
        if (this.drawStack != null) {
            GL11.glEnable((int)3553);
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.getRenderItem().func_82406_b(null, Minecraft.func_71410_x().func_110434_K(), this.drawStack, 0, 0);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
        }
    }

    @Override
    public Drawable.Type getTypeEnum() {
        return Drawable.Type.ITEM;
    }

    @Override
    public int getWidth() {
        return Math.round(16.0f * this.scale);
    }

    @Override
    public int getHeight() {
        return Math.round(16.0f * this.scale);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    protected void onUpdate() {
        this.drawStack = ItemIcon.findDrawStack(this.itemId, this.meta);
    }

    private static ItemStack findDrawStack(String itemId, int meta) {
        if (Strings.isNullOrEmpty((String)itemId)) {
            return null;
        }
        String[] itemSplit = itemId.split(":");
        if (itemSplit.length != 2) {
            return null;
        }
        Item item = GameRegistry.findItem((String)itemSplit[0], (String)itemSplit[1]);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, meta);
    }
}

