/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.ServerChatEvent;
import openperipheral.addons.api.TerminalRegisterEvent;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.addons.glasses.TileEntityGlassesBridge;

public class TerminalManagerServer {
    public static final TerminalManagerServer instance = new TerminalManagerServer();
    private final Map<Long, TileEntityGlassesBridge> listeners = new MapMaker().weakValues().makeMap();

    private TerminalManagerServer() {
    }

    @SubscribeEvent
    public void onServerChatEvent(ServerChatEvent event) {
        TileEntityGlassesBridge listener;
        EntityPlayerMP player = event.player;
        if (!event.message.startsWith("$$")) {
            return;
        }
        Long guid = TerminalUtils.tryGetTerminalGuid((EntityPlayer)player);
        if (guid != null && (listener = this.listeners.get(guid)) != null) {
            listener.onChatCommand(event.message.substring(2).trim(), (EntityPlayer)player);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onResetRequest(TerminalEvent.TerminalResetEvent evt) {
        TileEntityGlassesBridge listener = this.listeners.get(evt.terminalId);
        if (listener != null) {
            listener.handleResetRequest(evt);
        }
    }

    @SubscribeEvent
    public void onTerminalRegister(TerminalRegisterEvent evt) {
        TileEntityGlassesBridge listener = this.listeners.get(evt.terminalId);
        if (listener != null) {
            listener.registerTerminal(evt.player);
        }
    }

    @SubscribeEvent
    public void onGlassesEvent(GlassesEvent.GlassesClientEvent evt) {
        TileEntityGlassesBridge listener = this.listeners.get(evt.guid);
        if (listener != null) {
            listener.handleUserEvent(evt);
        }
    }

    public void registerBridge(long terminalId, TileEntityGlassesBridge bridge) {
        this.listeners.put(terminalId, bridge);
    }
}

