/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openmods.structured.IStructureElement;
import openmods.structured.StructuredDataMaster;
import openperipheral.addons.glasses.IDrawableContainer;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.GradientBox;
import openperipheral.addons.glasses.drawable.ItemIcon;
import openperipheral.addons.glasses.drawable.LiquidIcon;
import openperipheral.addons.glasses.drawable.SolidBox;
import openperipheral.addons.glasses.drawable.Text;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.ScriptObject;

@ScriptObject
@Asynchronous
@AdapterSourceName(value="glasses_surface")
public class SurfaceServer
extends StructuredDataMaster<Drawable, IStructureElement>
implements IDrawableContainer {
    @Override
    public synchronized Drawable getById(int id) {
        return (Drawable)this.containers.get(id - 1);
    }

    @Override
    public synchronized void clear() {
        for (Drawable drawable : this.containers.values()) {
            drawable.setDeleted();
        }
        this.removeAll();
    }

    @Override
    public synchronized Set<Integer> getAllIds() {
        return Collections.unmodifiableSet(this.containers.keySet());
    }

    @Override
    public synchronized Map<Integer, Drawable> getAllObjects() {
        return Collections.unmodifiableMap(this.containers);
    }

    private synchronized Drawable addDrawable(Drawable drawable) {
        int id = this.addContainer(drawable);
        drawable.onAdded(this, id);
        return drawable;
    }

    @Override
    public Drawable addText(short x, short y, String text, Integer color) {
        return this.addDrawable(new Text(x, y, text, (Integer)Objects.firstNonNull((Object)color, (Object)0xFFFFFF)));
    }

    @Override
    public Drawable addBox(short x, short y, short width, short height, Integer color, Float opacity) {
        return this.addDrawable(new SolidBox(x, y, width, height, (Integer)Objects.firstNonNull((Object)color, (Object)0xFFFFFF), ((Float)Objects.firstNonNull((Object)opacity, (Object)Float.valueOf(1.0f))).floatValue()));
    }

    @Override
    public Drawable addGradientBox(short x, short y, short width, short height, int color, float alpha, int color2, float alpha2, int gradient) {
        return this.addDrawable(new GradientBox(x, y, width, height, color, alpha, color2, alpha2, gradient));
    }

    @Override
    public Drawable addIcon(short x, short y, String id, Short meta) {
        return this.addDrawable(new ItemIcon(x, y, id, meta != null ? meta : (short)0));
    }

    @Override
    public Drawable addLiquid(short x, short y, short width, short height, String id) {
        return this.addDrawable(new LiquidIcon(x, y, width, height, id));
    }
}

