/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.client.fx.bolt.FXLightningBolt;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.VectorSimple;
import tuhljin.automagy.network.PacketHandler;
import tuhljin.automagy.tiles.TileEntityEssentiaLocus;
import tuhljin.automagy.tiles.TileEntityInventarium;

public class MessageParticles
implements IMessage,
IMessageHandler<MessageParticles, IMessage> {
    public static final short BREAKBLOCK = 0;
    public static final short BOLT_BLACK = 1;
    public static final short SMOKE = 2;
    public static final short ENDER_DISJUNCTION = 3;
    public static final short ABSORB_CLUSTER = 4;
    public static final short ENCHANTINGSYMBOLS = 5;
    public static final short ENCHANTINGSYMBOLS_REVERSE = 6;
    public static final short GRABLIQUID = 7;
    public static final short NETHERPLACED = 8;
    public static final short NETHERPLACED_NOSOUND = 9;
    protected short id;
    protected int dim;
    protected int x;
    protected int y;
    protected int z;
    protected int x2;
    protected int y2;
    protected int z2;

    public MessageParticles() {
    }

    public MessageParticles(int dim, int x, int y, int z, int x2, int y2, int z2, short id) {
        this.id = id;
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readShort();
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.x2 = buf.readInt();
        this.y2 = buf.readInt();
        this.z2 = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.id);
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.x2);
        buf.writeInt(this.y2);
        buf.writeInt(this.z2);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageParticles message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world.field_73011_w.field_76574_g == message.dim) {
            this.dim = message.dim;
            this.x = message.x;
            this.y = message.y;
            this.z = message.z;
            this.x2 = message.x2;
            this.y2 = message.y2;
            this.z2 = message.z2;
            switch (message.id) {
                case 0: {
                    this.showBreakBlock((World)world);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 7; ++i) {
                        this.showBolt((World)world, 5);
                    }
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "thaumcraft:zap", 0.2f, world.field_73012_v.nextFloat() * 0.5f + 0.4f, false);
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "random.eat", 0.7f, world.field_73012_v.nextFloat() * 0.5f + 0.1f, false);
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "random.eat", 0.5f, world.field_73012_v.nextFloat() * 0.5f + 1.0f, false);
                    break;
                }
                case 2: {
                    int num = this.x2 > 0 ? this.x2 : 35;
                    for (int i = 0; i < num; ++i) {
                        this.showSmoke((World)world);
                    }
                    break;
                }
                case 3: {
                    int num = this.x2 > 0 ? this.x2 : 20;
                    for (int i = 0; i < num; ++i) {
                        Thaumcraft.proxy.splooshFX((World)world, this.x, this.y, this.z);
                        Thaumcraft.proxy.splooshFX((World)world, this.x, this.y + 1, this.z);
                        Thaumcraft.proxy.splooshFX((World)world, this.x, this.y + 2, this.z);
                    }
                    break;
                }
                case 4: {
                    TileEntity te = world.func_147438_o(this.x, this.y, this.z);
                    int color = 0;
                    if (te instanceof TileEntityEssentiaLocus) {
                        ((TileEntityEssentiaLocus)te).ticksToAnim = 40;
                        color = 2;
                    } else if (te instanceof TileEntityInventarium) {
                        ((TileEntityInventarium)te).ticksToAnim = 40;
                        color = 0;
                    }
                    this.blockSparkle((World)world, this.x, this.y, this.z, color, 5);
                    this.blockSparkle((World)world, this.x2, this.y2, this.z2, color, 30);
                    this.blockSparkle((World)world, this.x2 - 1, this.y2, this.z2 - 1, color, 2);
                    this.blockSparkle((World)world, this.x2 - 1, this.y2, this.z2, color, 2);
                    this.blockSparkle((World)world, this.x2 - 1, this.y2, this.z2 + 1, color, 2);
                    this.blockSparkle((World)world, this.x2, this.y2, this.z2 - 1, color, 2);
                    this.blockSparkle((World)world, this.x2, this.y2, this.z2 + 1, color, 2);
                    this.blockSparkle((World)world, this.x2 + 1, this.y2, this.z2 - 1, color, 2);
                    this.blockSparkle((World)world, this.x2 + 1, this.y2, this.z2, color, 2);
                    this.blockSparkle((World)world, this.x2 + 1, this.y2, this.z2 + 1, color, 2);
                    break;
                }
                case 5: {
                    double destinationZ;
                    double destinationY;
                    double destinationX;
                    if (TjUtil.getDistanceBetweenPoints_squared(this.x, this.y, this.z, this.x2, this.y2, this.z2) >= 120.0) {
                        VectorSimple vec = new VectorSimple(this.x2, this.y2, this.z2, this.x, this.y, this.z);
                        vec.normalize();
                        vec.multiply(10.5);
                        destinationX = MathHelper.func_76128_c((double)((double)this.x + vec.x));
                        destinationY = MathHelper.func_76128_c((double)((double)this.y + vec.y + 1.8));
                        destinationZ = MathHelper.func_76128_c((double)((double)this.z + vec.z));
                    } else {
                        destinationX = this.x2;
                        destinationY = this.y2;
                        destinationZ = this.z2;
                    }
                    double xx = destinationX + 0.5;
                    double yy = destinationY + 1.8;
                    double zz = destinationZ + 0.5;
                    for (int i = 0; i < 30; ++i) {
                        world.func_72869_a("enchantmenttable", xx, yy, zz, (double)((float)((double)this.x - destinationX) + world.field_73012_v.nextFloat()) - 0.5, (double)((float)((double)this.y - destinationY) - world.field_73012_v.nextFloat() - 0.2f), (double)((float)((double)this.z - destinationZ) + world.field_73012_v.nextFloat()) - 0.5);
                    }
                    this.blockSparkle((World)world, this.x, this.y + 1, this.z, 6, 2);
                    this.blockSparkle((World)world, this.x, this.y + 1, this.z, 0, 2);
                    break;
                }
                case 6: {
                    double xx = (double)this.x + 0.5;
                    double yy = (double)this.y + 1.8;
                    double zz = (double)this.z + 0.5;
                    for (int i = 0; i < 30; ++i) {
                        world.func_72869_a("enchantmenttable", xx, yy, zz, (double)((float)(this.x2 - this.x) + world.field_73012_v.nextFloat()) - 0.5, (double)((float)(this.y2 - this.y) - world.field_73012_v.nextFloat() - 0.2f), (double)((float)(this.z2 - this.z) + world.field_73012_v.nextFloat()) - 0.5);
                    }
                    this.blockSparkle((World)world, this.x, this.y + 1, this.z, 6, 2);
                    this.blockSparkle((World)world, this.x, this.y + 1, this.z, 0, 2);
                    break;
                }
                case 7: {
                    int color = 7;
                    this.blockSparkle((World)world, this.x, this.y, this.z, color, 7);
                    break;
                }
                case 8: 
                case 9: {
                    for (int i = 0; i < 35; ++i) {
                        this.showSmoke((World)world);
                    }
                    int times = message.id == 9 ? 4 : 2;
                    for (int i = 0; i < times; ++i) {
                        Thaumcraft.proxy.furnaceLavaFx((World)world, this.x, this.y, this.z, -1, -1);
                        Thaumcraft.proxy.furnaceLavaFx((World)world, this.x, this.y, this.z, -1, 1);
                        Thaumcraft.proxy.furnaceLavaFx((World)world, this.x, this.y, this.z, 1, -1);
                        Thaumcraft.proxy.furnaceLavaFx((World)world, this.x, this.y, this.z, 1, 1);
                    }
                    if (message.id == 9) break;
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "mob.ghast.fireball", 0.5f, world.field_73012_v.nextFloat() * 0.5f + 0.2f, false);
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void showBreakBlock(World world) {
        try {
            Block block = world.func_147439_a(this.x, this.y, this.z);
            int md = world.func_72805_g(this.x, this.y, this.z);
            Minecraft.func_71410_x().field_71452_i.func_147215_a(this.x, this.y, this.z, block, md);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showBolt(World world, int color) {
        FXLightningBolt bolt = new FXLightningBolt(world, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, (double)this.x2 + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), (double)this.y2 + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), (double)this.z2 + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), world.field_73012_v.nextLong(), 20, 2.0f, 1);
        bolt.defaultFractal();
        bolt.setType(color);
        bolt.setWidth(0.015f);
        bolt.finalizeBolt();
    }

    @SideOnly(value=Side.CLIENT)
    private void showSmoke(World world) {
        world.func_72869_a("smoke", (double)this.x + 0.5, (double)this.y + 0.25 + world.field_73012_v.nextDouble(), (double)this.z + 0.5, world.field_73012_v.nextGaussian() * 0.05, 0.005, world.field_73012_v.nextGaussian() * 0.05);
    }

    public static void sendToClients(int range, World world, int x, int y, int z, int x2, int y2, int z2, short id) {
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.field_76574_g;
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dim, (double)x, (double)y, (double)z, (double)range);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticles(dim, x, y, z, x2, y2, z2, id), point);
    }

    public static void sendToClients(World world, int x, int y, int z, int x2, int y2, int z2, short id) {
        MessageParticles.sendToClients(20, world, x, y, z, x2, y2, z2, id);
    }

    private void blockSparkle(World world, int x, int y, int z, int color, int count) {
        Automagy.proxy.oldBlockSparkle(world, x, y, z, color, count);
    }
}

