/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import tuhljin.automagy.api.inventarium.IInventariumContentsProvider;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.IItemMap;
import tuhljin.automagy.lib.inventory.MappedItemsOrderedByTimeAdded;
import tuhljin.automagy.tiles.TileEntityInventarium;

public class FilteringItemList
implements IItemMap {
    protected Map<HashableItemWithoutSize, Integer> map;
    protected Map<HashableItemWithoutSize, Integer> cacheNoMetadata = null;
    protected Map<HashableItemWithoutSize, Integer> cacheNoNBT = null;
    protected Map<HashableItemWithoutSize, Integer> cacheNoMetadataOrNBT = null;

    public FilteringItemList() {
        this.map = this.createNewMap();
    }

    public FilteringItemList(ArrayList<ItemStack> list, boolean allowBelowOne) {
        this();
        for (ItemStack stack : list) {
            if (!allowBelowOne && stack.field_77994_a <= 0) continue;
            this.map.put(new HashableItemWithoutSize(stack), stack.field_77994_a);
        }
    }

    public FilteringItemList(FilteringItemList copySource) {
        this.map = new HashMap<HashableItemWithoutSize, Integer>(copySource.map);
    }

    public FilteringItemList(MappedItemsOrderedByTimeAdded copySource) {
        this.map = new HashMap<HashableItemWithoutSize, Integer>(copySource.map);
    }

    public FilteringItemList populateFromInventory(IInventory inv, boolean checkExtract) {
        return this.populateFromInventory(inv, -1, checkExtract);
    }

    public FilteringItemList populateFromInventory(IInventory inv, int side, boolean checkExtract) {
        this.cacheNoMetadata = null;
        this.cacheNoNBT = null;
        this.cacheNoMetadataOrNBT = null;
        this.map.clear();
        this.popFromInv(inv, side, checkExtract);
        return this;
    }

    public FilteringItemList populateFromInventories(ArrayList<IInventory> invs) {
        this.cacheNoMetadata = null;
        this.cacheNoNBT = null;
        this.cacheNoMetadataOrNBT = null;
        this.map.clear();
        for (IInventory inv : invs) {
            this.popFromInv(inv, -1, false);
        }
        return this;
    }

    public FilteringItemList populateFromInventariumContentsProviders(ArrayList<TileEntityInventarium.PairedContentsProvider> providers, int identifier) {
        this.cacheNoMetadata = null;
        this.cacheNoNBT = null;
        this.cacheNoMetadataOrNBT = null;
        this.map.clear();
        int size = providers.size();
        for (int i = 0; i < size; ++i) {
            TileEntityInventarium.PairedContentsProvider pair = providers.get(i);
            this.popFromInventariumContentsProvider(pair.provider, pair.te, identifier);
        }
        return this;
    }

    private void popFromInv(IInventory inv, int side, boolean checkExtract) {
        int[] slots;
        ISidedInventory sidedInv = null;
        if (side != -1 && inv instanceof ISidedInventory) {
            sidedInv = (ISidedInventory)inv;
        }
        if (sidedInv == null) {
            int numSlots = inv.func_70302_i_();
            slots = new int[numSlots];
            for (int i = 0; i < numSlots; ++i) {
                slots[i] = i;
            }
        } else {
            slots = sidedInv.func_94128_d(side);
        }
        for (int i1 = 0; i1 < slots.length; ++i1) {
            int slotNum = slots[i1];
            ItemStack stack = inv.func_70301_a(slotNum);
            if (stack == null || sidedInv != null && checkExtract && !sidedInv.func_102008_b(slotNum, stack, side)) continue;
            HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
            if (this.map.containsKey(item)) {
                this.map.put(item, TjUtil.overflowSafeAddInt(this.map.get(item), stack.field_77994_a));
                continue;
            }
            this.map.put(item, stack.field_77994_a);
        }
    }

    private void popFromInventariumContentsProvider(IInventariumContentsProvider inv, TileEntity te, int tickIdentifier) {
        ItemStack[] stacks = inv.getContents(te, tickIdentifier);
        if (stacks != null) {
            for (int i = 0; i < stacks.length; ++i) {
                ItemStack stack = stacks[i];
                if (stack == null) continue;
                HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
                if (this.map.containsKey(item)) {
                    this.map.put(item, TjUtil.overflowSafeAddInt(this.map.get(item), stack.field_77994_a));
                    continue;
                }
                this.map.put(item, stack.field_77994_a);
            }
        }
    }

    @Override
    public int get(HashableItemWithoutSize item) {
        Integer c = this.map.get(item);
        return c == null ? 0 : c;
    }

    @Override
    public void set(HashableItemWithoutSize item, int count) {
        this.set(item, count, false);
    }

    public void setZero(HashableItemWithoutSize item) {
        this.set(item, 0, true);
    }

    public void add(HashableItemWithoutSize item, int amount) {
        int count = this.get(item);
        this.set(item, TjUtil.overflowSafeAddInt(count, amount));
    }

    public void add(ItemStack stack) {
        this.add(new HashableItemWithoutSize(stack), stack.field_77994_a);
    }

    public void subtract(HashableItemWithoutSize item, int amount) {
        int count = this.get(item);
        this.set(item, TjUtil.overflowSafeSubtractInt(count, amount));
    }

    @Override
    public boolean containsKey(HashableItemWithoutSize item) {
        return this.map.containsKey(item);
    }

    @Override
    public Iterator<Map.Entry<HashableItemWithoutSize, Integer>> getIterator() {
        return this.map.entrySet().iterator();
    }

    public void set(HashableItemWithoutSize item, int count, boolean allowZero) {
        int val;
        Integer c;
        HashableItemWithoutSize item2;
        if ((count = Math.max(count, 0)) == 0 && allowZero && !this.map.containsKey(item)) {
            this.map.put(item, 0);
            return;
        }
        int diff = count - this.get(item);
        if (diff == 0) {
            return;
        }
        if (count > 0) {
            this.map.put(item, count);
        } else if (this.map.containsKey(item)) {
            if (allowZero) {
                this.map.put(item, 0);
            } else {
                this.map.remove(item);
            }
        }
        if (this.cacheNoMetadata != null) {
            item2 = new HashableItemWithoutSize(item, true, false);
            c = this.cacheNoMetadata.get(item2);
            val = TjUtil.overflowSafeAddInt(c == null ? 0 : c, diff);
            if (val > 0) {
                this.cacheNoMetadata.put(item2, val);
            } else if (this.cacheNoMetadata.containsKey(item2)) {
                if (allowZero) {
                    this.cacheNoMetadata.put(item2, 0);
                } else {
                    this.cacheNoMetadata.remove(item2);
                }
            }
        }
        if (this.cacheNoNBT != null) {
            item2 = new HashableItemWithoutSize(item, false, true);
            c = this.cacheNoNBT.get(item2);
            val = TjUtil.overflowSafeAddInt(c == null ? 0 : c, diff);
            if (val > 0) {
                this.cacheNoNBT.put(item2, val);
            } else if (this.cacheNoNBT.containsKey(item2)) {
                if (allowZero) {
                    this.cacheNoNBT.put(item2, 0);
                } else {
                    this.cacheNoNBT.remove(item2);
                }
            }
        }
        if (this.cacheNoMetadataOrNBT != null) {
            item2 = new HashableItemWithoutSize(item, true, true);
            c = this.cacheNoMetadataOrNBT.get(item2);
            val = TjUtil.overflowSafeAddInt(c == null ? 0 : c, diff);
            if (val > 0) {
                this.cacheNoMetadataOrNBT.put(item2, val);
            } else if (this.cacheNoMetadataOrNBT.containsKey(item2)) {
                if (allowZero) {
                    this.cacheNoMetadataOrNBT.put(item2, 0);
                } else {
                    this.cacheNoMetadataOrNBT.remove(item2);
                }
            }
        }
    }

    public int get(HashableItemWithoutSize item, boolean ignoreMetadata, boolean ignoreNBT) {
        Map<HashableItemWithoutSize, Integer> ref;
        if (ignoreMetadata) {
            if (ignoreNBT) {
                if (this.cacheNoMetadataOrNBT == null) {
                    this.generateCache(true, true);
                }
                ref = this.cacheNoMetadataOrNBT;
            } else {
                if (this.cacheNoMetadata == null) {
                    this.generateCache(true, false);
                }
                ref = this.cacheNoMetadata;
            }
        } else if (ignoreNBT) {
            if (this.cacheNoNBT == null) {
                this.generateCache(false, true);
            }
            ref = this.cacheNoNBT;
        } else {
            ref = this.map;
        }
        Integer c = ref.get(new HashableItemWithoutSize(item, ignoreMetadata, ignoreNBT));
        return c == null ? 0 : c;
    }

    public int size() {
        return this.map.size();
    }

    public void clearCache() {
        this.cacheNoMetadata = null;
        this.cacheNoNBT = null;
        this.cacheNoMetadataOrNBT = null;
    }

    public FilteringItemList getDifferences(FilteringItemList previousList) {
        FilteringItemList diff = new FilteringItemList();
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : this.map.entrySet()) {
            HashableItemWithoutSize key = entry.getKey();
            if (previousList.map.containsKey(key)) {
                int oldValue = previousList.map.get(key);
                int newValue = entry.getValue();
                if (newValue <= oldValue) continue;
                diff.map.put(key, newValue - oldValue);
                continue;
            }
            diff.map.put(key, entry.getValue());
        }
        return diff;
    }

    protected void generateCache(boolean ignoreMetadata, boolean ignoreNBT) {
        Map<HashableItemWithoutSize, Integer> cache = this.createNewMap();
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : this.map.entrySet()) {
            HashableItemWithoutSize item;
            Integer c = cache.get(item = new HashableItemWithoutSize(entry.getKey(), ignoreMetadata, ignoreNBT));
            cache.put(item, TjUtil.overflowSafeAddInt(c == null ? 0 : c, entry.getValue()));
        }
        if (ignoreMetadata) {
            if (ignoreNBT) {
                this.cacheNoMetadataOrNBT = cache;
            } else {
                this.cacheNoMetadata = cache;
            }
        } else if (ignoreNBT) {
            this.cacheNoNBT = cache;
        }
    }

    protected Map<HashableItemWithoutSize, Integer> createNewMap() {
        return new HashMap<HashableItemWithoutSize, Integer>();
    }

    @Override
    public ArrayList<ItemStack> getItemStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : this.map.entrySet()) {
            stacks.add(entry.getKey().getItemStack(entry.getValue()));
        }
        return stacks;
    }

    @Override
    public FilteringItemList copy() {
        return new FilteringItemList(this);
    }
}

