/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility.foresty;

import exnihilo.compatibility.foresty.FlowerType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IIndividual;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Surrounding {
    public Map<String, Integer> blocks = new HashMap<String, Integer>();
    public Map<String, Integer> flowers = new HashMap<String, Integer>();
    public int leafCount;
    public String blockAbove;

    public void addBlock(World world, int x, int y, int z) {
        String key;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != null && block.isLeaves((IBlockAccess)world, x, y, z)) {
            ++this.leafCount;
        }
        if (this.blocks.containsKey(key = block + ":" + meta)) {
            int count = this.blocks.get(key);
            this.blocks.put(key, count + 1);
        } else {
            this.blocks.put(key, 1);
        }
        this.tryAddFlower(world, null, x, y, z);
    }

    public void setBlockAbove(Block block, int meta) {
        this.blockAbove = block + ":" + meta;
    }

    public void tryAddFlower(World world, IIndividual individual, int x, int y, int z) {
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersVanilla", world, individual, x, y, z)) {
            this.addFlower(FlowerType.Normal);
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersNether", world, individual, x, y, z)) {
            this.addFlower(FlowerType.Nether);
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersEnd", world, individual, x, y, z)) {
            this.addFlower(FlowerType.End);
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersJungle", world, individual, x, y, z)) {
            this.addFlower(FlowerType.Jungle);
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersMushrooms", world, individual, x, y, z)) {
            this.addFlower(FlowerType.Mushroom);
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersCacti", world, individual, x, y, z)) {
            this.addFlower(FlowerType.Cactus);
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower("flowersGourd", world, individual, x, y, z)) {
            this.addFlower(FlowerType.Gourd);
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150392_bi) {
            this.addFlower(FlowerType.Water);
        }
    }

    private void addFlower(FlowerType type) {
        String key = type.name();
        if (this.flowers.containsKey(key)) {
            int count = this.flowers.get(key);
            this.flowers.put(key, count + 1);
        } else {
            this.flowers.put(key, 1);
        }
    }

    public int getFlowerCount(FlowerType type) {
        String key = type.name();
        switch (type) {
            case None: {
                return 0;
            }
        }
        if (this.flowers.containsKey(key)) {
            return this.flowers.get(key);
        }
        return 0;
    }
}

