/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility;

import cofh.api.modhelpers.ThermalExpansionHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.ENBlocks;
import exnihilo.ExNihilo;
import exnihilo.compatibility.OreList;
import exnihilo.data.ModData;
import exnihilo.registries.HeatRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ThermalExpansion {
    public static void loadCompatibility() {
        if (ModData.OVERWRITE_DEFAULT_PULVERIZER_RECIPES) {
            ThermalExpansion.overwritePulverizerRecipe(3200, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), 10, true);
            ThermalExpansion.overwritePulverizerRecipe(3200, new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ENBlocks.Dust), 10, true);
            ThermalExpansion.overwritePulverizerRecipe(3200, new ItemStack(Blocks.field_150424_aL), new ItemStack(ENBlocks.NetherGravel), (ItemStack)OreDictionary.getOres((String)"dustSulfur").get(0), 15, true);
            ExNihilo.log.info("Pulverizer: overwrote the cobble->sand recipe with cobble->gravel");
            ExNihilo.log.info("Pulverizer: added recipe for gravel->sand");
        }
        ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)new ItemStack((Block)Blocks.field_150354_m), (ItemStack)new ItemStack(ENBlocks.Dust));
        ExNihilo.log.info("Pulverizer: added recipe for sand->dust");
        ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)new ItemStack(Blocks.field_150377_bs), (ItemStack)new ItemStack(ENBlocks.EnderGravel));
        Block pyrotheum = FluidRegistry.getFluid((String)"pyrotheum").getBlock();
        if (pyrotheum != null) {
            HeatRegistry.register(pyrotheum, 0.5f);
            HeatRegistry.register(pyrotheum, 0, 0.7f);
            ExNihilo.log.info("Added blazing pyrotheum as a crucible heat source");
        }
        ExNihilo.log.info("--- Thermal Expansion Integration Complete!");
    }

    public static void overwritePulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        ThermalExpansionHelper.removePulverizerRecipe((ItemStack)input);
        ThermalExpansionHelper.addPulverizerRecipe((int)energy, (ItemStack)input, (ItemStack)primaryOutput, (ItemStack)secondaryOutput, (int)secondaryChance);
    }

    public static void TryRegisterOre(String name, Block block) {
        name = name.replace("ender_", "");
        if ((name = name.replace("nether_", "")).toLowerCase().equals("iron")) {
            ThermalExpansion.RegisterOre(OreList.Type.Iron, block);
        }
        if (name.toLowerCase().equals("gold")) {
            ThermalExpansion.RegisterOre(OreList.Type.Gold, block);
        }
        if (name.toLowerCase().equals("copper")) {
            ThermalExpansion.RegisterOre(OreList.Type.Copper, block);
        }
        if (name.toLowerCase().equals("tin")) {
            ThermalExpansion.RegisterOre(OreList.Type.Tin, block);
        }
        if (name.toLowerCase().equals("nickel")) {
            ThermalExpansion.RegisterOre(OreList.Type.Nickel, block);
        }
        if (name.toLowerCase().equals("platinum")) {
            ThermalExpansion.RegisterOre(OreList.Type.Platinum, block);
        }
        if (name.toLowerCase().equals("silver")) {
            ThermalExpansion.RegisterOre(OreList.Type.Silver, block);
        }
        if (name.toLowerCase().equals("lead")) {
            ThermalExpansion.RegisterOre(OreList.Type.Lead, block);
        }
    }

    public static void RegisterOre(OreList.Type ore, Block block) {
        ItemStack iblock = new ItemStack(block);
        switch (ore) {
            case Iron: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustIron", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustNickel", (int)1);
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, (ItemStack)secondary, (int)10);
                break;
            }
            case Gold: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustGold", (int)2);
                ItemStack secondary = null;
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, secondary, (int)10);
                break;
            }
            case Tin: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustTin", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustIron", (int)1);
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, (ItemStack)secondary, (int)10);
                break;
            }
            case Copper: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustCopper", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustGold", (int)1);
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, (ItemStack)secondary, (int)10);
                break;
            }
            case Silver: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustSilver", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustLead", (int)1);
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, (ItemStack)secondary, (int)10);
                break;
            }
            case Lead: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustLead", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustSilver", (int)1);
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, (ItemStack)secondary, (int)10);
                break;
            }
            case Nickel: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustNickel", (int)2);
                ItemStack secondary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustPlatinum", (int)1);
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, (ItemStack)secondary, (int)10);
                break;
            }
            case Platinum: {
                ItemStack primary = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustPlatinum", (int)2);
                ItemStack secondary = null;
                ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)iblock, (ItemStack)primary, secondary, (int)10);
                break;
            }
        }
    }
}

