/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiXPBottler;
import openblocks.common.LiquidXpUtils;
import openblocks.common.container.ContainerXPBottler;
import openmods.api.IHasGui;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.gamelogic.WorkerLogic;
import openmods.gui.misc.IConfigurableGuiSlots;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableSides;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.MiscUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

public class TileEntityXPBottler
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IConfigurableGuiSlots<AutoSlots> {
    public static final int TANK_CAPACITY = LiquidXpUtils.xpToLiquidRatio(8);
    public static final int PROGRESS_TICKS = 40;
    protected static final ItemStack GLASS_BOTTLE = new ItemStack(Items.field_151069_bo, 1);
    protected static final ItemStack XP_BOTTLE = new ItemStack(Items.field_151062_by, 1);
    public List<ForgeDirection> surroundingTanks = new ArrayList<ForgeDirection>();
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "xpbottler", true, 2){

        public boolean func_94041_b(int slot, ItemStack itemstack) {
            if (slot != Slots.input.ordinal()) {
                return false;
            }
            return itemstack.func_77973_b() == Items.field_151069_bo;
        }
    });
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter sided = new SidedInventoryAdapter((IInventory)this.inventory);
    private SyncableInt progress;
    private SyncableSides glassSides;
    private SyncableSides xpBottleSides;
    private SyncableSides xpSides;
    private SyncableFlags automaticSlots;
    private SyncableTank tank;
    private final WorkerLogic logic = new WorkerLogic(this.progress, 40);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Drain((IReadableBitMap)this.xpSides, (IFluidTank)this.tank);

    protected void createSyncedFields() {
        this.progress = new SyncableInt();
        this.glassSides = new SyncableSides();
        this.xpBottleSides = new SyncableSides();
        this.xpSides = new SyncableSides();
        this.automaticSlots = SyncableFlags.create((int)AutoSlots.values().length);
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
    }

    public TileEntityXPBottler() {
        this.sided.registerSlot((Enum)Slots.input, (IReadableBitMap)this.glassSides, true, false);
        this.sided.registerSlot((Enum)Slots.output, (IReadableBitMap)this.xpBottleSides, false, true);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                this.tank.fillFromSides(10, this.field_145850_b, this.getPosition(), this.xpSides.getValue());
            }
            if (this.shouldAutoOutput() && this.hasOutputStack()) {
                ItemDistribution.moveItemsToOneOfSides((TileEntity)this, (IInventory)this.inventory, (int)Slots.output.ordinal(), (int)1, (Iterable)this.xpBottleSides.getValue(), (boolean)true);
            }
            if (this.shouldAutoInput() && !this.hasGlassInInput()) {
                ItemDistribution.moveItemsFromOneOfSides((TileEntity)this, (IInventory)this.inventory, (ItemStack)GLASS_BOTTLE, (int)1, (int)Slots.input.ordinal(), (Iterable)this.glassSides.getValue(), (boolean)true);
            }
            this.logic.checkWorkCondition(this.hasSpaceInOutput() && this.hasGlassInInput() && this.isTankFull());
            if (this.logic.update()) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "openblocks:bottler.signal", 0.5f, 0.8f);
                this.inventory.func_70298_a(Slots.input.ordinal(), 1);
                this.tank.setFluid(null);
                ItemStack outputStack = this.inventory.func_70301_a(Slots.output.ordinal());
                if (outputStack == null) {
                    this.inventory.func_70299_a(Slots.output.ordinal(), XP_BOTTLE.func_77946_l());
                } else {
                    ++outputStack.field_77994_a;
                }
                this.inventory.onInventoryChanged(Slots.output.ordinal());
            }
            this.sync();
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerXPBottler((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiXPBottler(new ContainerXPBottler((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public IValueProvider<Integer> getProgress() {
        return this.progress;
    }

    public boolean hasOutputStack() {
        ItemStack outputStack = this.inventory.func_70301_a(1);
        return outputStack != null && outputStack.field_77994_a > 0;
    }

    public boolean shouldAutoInput() {
        return this.automaticSlots.get((Enum)AutoSlots.input);
    }

    public boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    public boolean hasGlassInInput() {
        ItemStack inputStack = this.inventory.func_70301_a(Slots.input.ordinal());
        return inputStack != null && inputStack.func_77969_a(GLASS_BOTTLE);
    }

    public boolean hasSpaceInOutput() {
        ItemStack outputStack = this.inventory.func_70301_a(Slots.output.ordinal());
        return outputStack == null || outputStack.func_77969_a(XP_BOTTLE) && outputStack.field_77994_a < outputStack.func_77976_d();
    }

    public boolean isTankFull() {
        return this.tank.getFluidAmount() == this.tank.getCapacity();
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    private SyncableSides selectSlotMap(AutoSlots slot) {
        switch (slot) {
            case input: {
                return this.glassSides;
            }
            case output: {
                return this.xpBottleSides;
            }
            case xp: {
                return this.xpSides;
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    public IValueProvider<Set<ForgeDirection>> createAllowedDirectionsProvider(AutoSlots slot) {
        return this.selectSlotMap(slot);
    }

    public IWriteableBitMap<ForgeDirection> createAllowedDirectionsReceiver(AutoSlots slot) {
        SyncableSides dirs = this.selectSlotMap(slot);
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)dirs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<Boolean> createAutoFlagProvider(AutoSlots slot) {
        return BitMapUtils.singleBitProvider((IReadableBitMap)this.automaticSlots, (Object)slot.ordinal());
    }

    public IValueReceiver<Boolean> createAutoSlotReceiver(AutoSlots slot) {
        IRpcIntBitMap bits = (IRpcIntBitMap)this.createRpcProxy((ISyncableObject)this.automaticSlots, IRpcIntBitMap.class, new Class[0]);
        return BitMapUtils.singleBitReceiver((IRpcIntBitMap)bits, (int)slot.ordinal());
    }

    public static enum AutoSlots {
        input,
        output,
        xp;

    }

    public static enum Slots {
        input,
        output;

    }
}

