/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.ctmlib;

import com.cricketcraft.chisel.api.IFacade;
import com.cricketcraft.ctmlib.CTMLib;
import com.cricketcraft.ctmlib.Dir;
import com.google.common.collect.Maps;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CTM {
    protected static int[] submapOffsets = new int[]{4, 5, 1, 0};
    protected static TIntObjectMap<Dir[]> submapMap = new TIntObjectHashMap();
    protected static EnumMap<Dir, Boolean> connectionMap = Maps.newEnumMap(Dir.class);
    public static boolean disableObscuredFaceCheckConfig = false;
    public Boolean disableObscuredFaceCheck = null;

    protected CTM() {
    }

    public static CTM getInstance() {
        return new CTM();
    }

    public int[] getSubmapIndices(IBlockAccess world, int x, int y, int z, int side) {
        int[] ret = new int[]{18, 19, 17, 16};
        if (world == null) {
            return ret;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        this.buildConnectionMap(world, x, y, z, side, block, meta);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(ret, i);
        }
        return ret;
    }

    public void buildConnectionMap(IBlockAccess world, int x, int y, int z, int side, Block block, int meta) {
        for (Dir dir : Dir.VALUES) {
            connectionMap.put(dir, dir.isConnected(this, world, x, y, z, side, block, meta));
        }
    }

    private void fillSubmaps(int[] ret, int idx) {
        Dir[] dirs = (Dir[])submapMap.get(idx);
        if (this.connectedOr(dirs[0], dirs[1])) {
            ret[idx] = this.connectedAnd(dirs) ? submapOffsets[idx] : submapOffsets[idx] + (this.connected(dirs[0]) ? 2 : 0) + (this.connected(dirs[1]) ? 8 : 0);
        }
    }

    public boolean connected(Dir dir) {
        return connectionMap.get((Object)dir);
    }

    public boolean connectedAnd(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    private boolean connectedOr(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(IBlockAccess world, int x, int y, int z, int side, Block block, int meta) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        return this.isConnected(world, x, y, z, dir, block, meta);
    }

    public boolean isConnected(IBlockAccess world, int x, int y, int z, ForgeDirection dir, Block block, int meta) {
        boolean ret;
        Block obscuring;
        int x2 = x + dir.offsetX;
        int y2 = y + dir.offsetY;
        int z2 = z + dir.offsetZ;
        boolean disableObscured = this.disableObscuredFaceCheck == null ? disableObscuredFaceCheckConfig : this.disableObscuredFaceCheck;
        Block con = this.getBlockOrFacade(world, x, y, z, dir.ordinal());
        Block block2 = obscuring = disableObscured ? null : this.getBlockOrFacade(world, x2, y2, z2, dir.ordinal());
        if (con == null) {
            return false;
        }
        boolean bl = ret = con.equals(block) && this.getBlockOrFacadeMetadata(world, x, y, z, dir.ordinal()) == meta;
        if (obscuring == null) {
            return ret;
        }
        return ret &= !obscuring.equals(block) || this.getBlockOrFacadeMetadata(world, x2, y2, z2, dir.ordinal()) != meta;
    }

    public int getBlockOrFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        Block blk = world.func_147439_a(x, y, z);
        if (CTMLib.chiselLoaded()) {
            return this.getFacadeMeta(blk, world, x, y, z, side);
        }
        return world.func_72805_g(x, y, z);
    }

    private int getFacadeMeta(Block blk, IBlockAccess world, int x, int y, int z, int side) {
        if (blk instanceof IFacade) {
            return ((IFacade)blk).getFacadeMetadata(world, x, y, z, side);
        }
        return world.func_72805_g(x, y, z);
    }

    public Block getBlockOrFacade(IBlockAccess world, int x, int y, int z, int side) {
        Block blk = world.func_147439_a(x, y, z);
        if (CTMLib.chiselLoaded()) {
            return this.getFacade(blk, world, x, y, z, side);
        }
        return blk;
    }

    private Block getFacade(Block blk, IBlockAccess world, int x, int y, int z, int side) {
        if (blk instanceof IFacade) {
            blk = ((IFacade)blk).getFacade(world, x, y, z, side);
        }
        return blk;
    }

    static {
        for (Dir dir : Dir.VALUES) {
            connectionMap.put(dir, false);
        }
        submapMap.put(0, (Object)new Dir[]{Dir.BOTTOM, Dir.LEFT, Dir.BOTTOM_LEFT});
        submapMap.put(1, (Object)new Dir[]{Dir.BOTTOM, Dir.RIGHT, Dir.BOTTOM_RIGHT});
        submapMap.put(2, (Object)new Dir[]{Dir.TOP, Dir.RIGHT, Dir.TOP_RIGHT});
        submapMap.put(3, (Object)new Dir[]{Dir.TOP, Dir.LEFT, Dir.TOP_LEFT});
    }
}

