/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.data.ISided;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GarageDoor
implements ISided {
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_GLASS_TOP = 1;
    public static final int TYPE_GLASS = 2;
    public static final int TYPE_SIDING = 3;
    public static final int TYPE_HIDDEN = 4;
    public static final int STATE_CLOSED = 0;
    public static final int STATE_OPEN = 1;
    public static final byte DOOR_NONRIGID = 0;
    public static final byte DOOR_RIGID = 1;

    public int getType(TEBase TE) {
        return TE.getData() & 0xF;
    }

    public void setType(TEBase TE, int type) {
        int temp = TE.getData() & 0xFFFFFFF0 | type;
        TE.setData(temp);
    }

    @Override
    public ForgeDirection getDirection(TEBase TE) {
        int side = (TE.getData() & 0x70) >> 4;
        return ForgeDirection.getOrientation((int)side);
    }

    @Override
    public void setDirection(TEBase TE, ForgeDirection dir) {
        int temp = TE.getData() & 0xFFFFFF8F | dir.ordinal() << 4;
        TE.setData(temp);
    }

    public int getState(TEBase TE) {
        return (TE.getData() & 0x80) >> 7;
    }

    public void setState(TEBase TE, int state, boolean playSound) {
        int temp = TE.getData() & 0xFFFFFF7F | state << 7;
        World world = TE.func_145831_w();
        if (!world.field_72995_K && playSound) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 0);
        }
        TE.setData(temp);
    }

    public boolean isRigid(TEBase TE) {
        return this.getRigidity(TE) == 1;
    }

    public int getRigidity(TEBase TE) {
        return (TE.getData() & 0x100) >> 8;
    }

    public void setRigidity(TEBase TE, int rigidity) {
        int temp = TE.getData() & 0xFFFFFEFF | rigidity << 8;
        TE.setData(temp);
    }

    public void setHost(TEBase TE) {
        int temp = TE.getData() | 0x200;
        TE.setData(temp);
    }

    public boolean isHost(TEBase TE) {
        return (TE.getData() & 0x200) > 0;
    }

    public boolean isOpen(TEBase TE) {
        return this.getState(TE) == 1;
    }

    public boolean isBottommost(TEBase TE) {
        return !TE.func_145831_w().func_147439_a(TE.field_145851_c, TE.field_145848_d - 1, TE.field_145849_e).equals(BlockRegistry.blockCarpentersGarageDoor);
    }

    public TEBase getTopmost(World world, int x, int y, int z) {
        while (world.func_147439_a(x, ++y, z).equals(BlockRegistry.blockCarpentersGarageDoor)) {
        }
        return (TEBase)world.func_147438_o(x, y - 1, z);
    }

    public TEBase getBottommost(World world, int x, int y, int z) {
        while (world.func_147439_a(x, --y, z).equals(BlockRegistry.blockCarpentersGarageDoor)) {
        }
        return (TEBase)world.func_147438_o(x, y + 1, z);
    }

    public boolean isVisible(TEBase TE) {
        if (this.isOpen(TE)) {
            return this.isHost(TE);
        }
        return true;
    }
}

