/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockCoord {
    public final int x;
    public final int y;
    public final int z;

    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockCoord(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public BlockCoord(Entity e) {
        this(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
    }

    public BlockCoord(BlockCoord bc) {
        this.x = bc.x;
        this.y = bc.y;
        this.z = bc.z;
    }

    public BlockCoord getLocation(ForgeDirection dir) {
        return new BlockCoord(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    public int distanceSquared(BlockCoord other) {
        int dx = this.x - other.x;
        int dy = this.y - other.y;
        int dz = this.z - other.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public int distance(BlockCoord other) {
        double dsq = this.distanceSquared(other);
        return (int)Math.ceil(Math.sqrt(dsq));
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockCoord other = (BlockCoord)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "BlockCoord [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    public boolean equals(int xCoord, int yCoord, int zCoord) {
        return this.x == xCoord && this.y == yCoord && this.z == zCoord;
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static BlockCoord readFromBuf(ByteBuf buf) {
        return new BlockCoord(buf.readInt(), buf.readInt(), buf.readInt());
    }
}

