/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import crazypants.enderio.machine.enchanter.GuiEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class EnchanterRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"enderio.nei.enchanter");
    }

    public String getGuiTexture() {
        return "enderio:textures/gui/enchanter.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiEnchanter.class;
    }

    public String getOverlayIdentifier() {
        return "EIOEnchanter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(149, -3, 16, 16), "EIOEnchanter", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null || result.func_77973_b() != Items.field_151134_bR) {
            return;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)result);
        List<EnchanterRecipe> recipes = EnchanterRecipeManager.getInstance().getRecipes();
        for (Number id : enchants.keySet()) {
            Enchantment ench;
            if (id == null || id.intValue() < 0 || id.intValue() >= Enchantment.field_77331_b.length || (ench = Enchantment.field_77331_b[id.intValue()]) == null || ench.func_77320_a() == null) continue;
            for (EnchanterRecipe recipe : recipes) {
                if (!recipe.isValid() || !recipe.getEnchantment().func_77320_a().equals(ench.func_77320_a())) continue;
                EnchantmentData enchantment = new EnchantmentData(recipe.getEnchantment(), 1);
                ItemStack output = new ItemStack((Item)Items.field_151134_bR);
                Items.field_151134_bR.func_92115_a(output, enchantment);
                EnchanterRecipeNEI rec = new EnchanterRecipeNEI(recipe, output, enchantment);
                this.arecipes.add(rec);
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("EIOEnchanter") && ((Object)((Object)this)).getClass() == EnchanterRecipeHandler.class) {
            List<EnchanterRecipe> recipes = EnchanterRecipeManager.getInstance().getRecipes();
            for (EnchanterRecipe recipe : recipes) {
                if (!recipe.isValid()) continue;
                EnchantmentData enchantment = new EnchantmentData(recipe.getEnchantment(), 1);
                ItemStack output = new ItemStack((Item)Items.field_151134_bR);
                Items.field_151134_bR.func_92115_a(output, enchantment);
                EnchanterRecipeNEI rec = new EnchanterRecipeNEI(recipe, output, enchantment);
                this.arecipes.add(rec);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<EnchanterRecipe> recipes = EnchanterRecipeManager.getInstance().getRecipes();
        for (EnchanterRecipe recipe : recipes) {
            if (!recipe.isValid()) continue;
            EnchantmentData enchantment = new EnchantmentData(recipe.getEnchantment(), 1);
            ItemStack output = new ItemStack((Item)Items.field_151134_bR);
            Items.field_151134_bR.func_92115_a(output, enchantment);
            EnchanterRecipeNEI rec = new EnchanterRecipeNEI(recipe, output, enchantment);
            if (!rec.contains(rec.input, ingredient)) continue;
            rec.setIngredientPermutation(rec.input, ingredient);
            this.arecipes.add(rec);
        }
    }

    public void drawExtras(int recipeIndex) {
        EnchanterRecipeNEI recipe = (EnchanterRecipeNEI)((Object)this.arecipes.get(recipeIndex));
        GuiDraw.drawStringC((String)recipe.getEnchantName(), (int)83, (int)10, (int)0x808080, (boolean)false);
        int cost = TileEnchanter.getEnchantmentCost(recipe.recipe, 1);
        if (cost > 0) {
            String s = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{cost});
            GuiDraw.drawStringC((String)s, (int)83, (int)46, (int)8453920);
        }
        IconEIO.RECIPE_BUTTON.renderIcon(149.0, -3.0, 16.0, 16.0, 0.0, true);
    }

    public List<ItemStack> getInputs(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] equivs = input.getEquivelentInputs();
        if (equivs != null && equivs.length > 0) {
            result.addAll(Arrays.asList(equivs));
        }
        return result;
    }

    public class EnchanterRecipeNEI
    extends TemplateRecipeHandler.CachedRecipe {
        private ArrayList<PositionedStack> input;
        private PositionedStack output;
        private EnchantmentData enchData;
        private EnchanterRecipe recipe;

        public String getEnchantName() {
            return StatCollector.func_74838_a((String)this.enchData.field_76302_b.func_77320_a());
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(EnchanterRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public EnchanterRecipeNEI(EnchanterRecipe recipe, ItemStack result, EnchantmentData enchData) {
            super((TemplateRecipeHandler)EnchanterRecipeHandler.this);
            this.recipe = recipe;
            this.input = new ArrayList();
            this.input.add(new PositionedStack((Object)new ItemStack(Items.field_151099_bA), 22, 24));
            this.input.add(new PositionedStack(EnchanterRecipeHandler.this.getInputs(recipe.getInput()), 71, 24));
            this.output = new PositionedStack((Object)result, 129, 24);
            this.enchData = enchData;
        }
    }
}

