/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.xp;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import crazypants.util.FluidUtil;
import crazypants.util.ITankAccess;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileExperienceOblisk
extends AbstractMachineEntity
implements IFluidHandler,
IHaveExperience,
ITankAccess {
    private ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.xpObeliskMaxXpLevel));

    public TileExperienceOblisk() {
        super(new SlotDefinition(0, 0, 0));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockExperienceObelisk.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround(new PacketExperianceContainer(this), this);
            this.xpCont.setDirty(false);
        }
        return false;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        boolean res = super.doPull(dir);
        FluidUtil.doPull(this, dir, Config.fluidConduitMaxIoRate);
        return res;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        boolean res = super.doPush(dir);
        FluidUtil.doPush(this, dir, Config.fluidConduitMaxIoRate);
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canFill(from, fluid);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.xpCont.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.xpCont.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.xpCont.drain(from, maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.xpCont.getTankInfo(from);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.xpCont.readFromNBT(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        this.xpCont.writeToNBT(nbtRoot);
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    @Override
    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    @Override
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    @Override
    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }
}

