/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.tank.FluidTankEio;
import crazypants.enderio.machine.tank.PacketTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.BlockCoord;
import crazypants.util.FluidUtil;
import crazypants.util.ITankAccess;
import crazypants.util.ItemUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileTank
extends AbstractMachineEntity
implements IFluidHandler,
ITankAccess {
    private static int IO_MB_TICK = 100;
    protected FluidTankEio tank;
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;
    private Fluid lastFluid = null;

    public TileTank(int meta) {
        super(new SlotDefinition(0, 1, 2, 3, -1, -1));
        this.tank = meta == 1 ? new FluidTankEio(32000) : new FluidTankEio(16000);
    }

    public TileTank() {
        this(0);
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.tank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, loc = this.getLocation().getLocation(dir))) != null && target.canFill(dir.getOpposite(), this.tank.getFluid().getFluid())) {
            FluidStack push = this.tank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.getOpposite(), push, true);
            if (filled > 0) {
                this.tank.drain(filled, true);
                this.tankDirty = true;
                return res;
            }
        }
        return res;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, loc = this.getLocation().getLocation(dir))) != null) {
            if (this.tank.getFluidAmount() > 0) {
                FluidStack canPull = this.tank.getFluid().copy();
                canPull.amount = this.tank.getCapacity() - this.tank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.tank.fill(drained, true);
                    this.tankDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.getOpposite());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.tank.fill(drained, true);
                        this.tankDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    int fillInternal(FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(resource, doDrain);
    }

    FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        FluidStack res = this.tank.drain(resource, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(maxDrain, doDrain);
    }

    FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack res = this.tank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFill(from) && fluid != null && (this.tank.getFluidAmount() > 0 && this.tank.getFluid().fluidID == fluid.getID() || this.tank.getFluidAmount() == 0);
    }

    private boolean canFill(ForgeDirection from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PUSH && mode != IoMode.DISABLED;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrain(from) && this.tank.canDrainFluidType(fluid);
    }

    private boolean canDrain(ForgeDirection from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PULL && mode != IoMode.DISABLED;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    @Override
    public String getMachineName() {
        return "tank";
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack item) {
        if (i == 0) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (fluid != null) {
                return true;
            }
            if (item.func_77973_b() == Items.field_151131_as) {
                return true;
            }
            if (item.func_77973_b() == Items.field_151129_at) {
                return true;
            }
            return item.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)item.func_77973_b()).getFluid(item) != null;
        }
        if (i == 1) {
            if (item.func_77973_b() instanceof IFluidContainerItem && (((IFluidContainerItem)item.func_77973_b()).getFluid(item) == null || ((IFluidContainerItem)item.func_77973_b()).getFluid((ItemStack)item).amount < ((IFluidContainerItem)item.func_77973_b()).getCapacity(item))) {
                return true;
            }
            return FluidContainerRegistry.isEmptyContainer((ItemStack)item) || item.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean res = this.processItems(redstoneCheckPassed);
        int filledLevel = this.getFilledLevel();
        if (this.lastUpdateLevel != filledLevel) {
            this.lastUpdateLevel = filledLevel;
            this.tankDirty = false;
            return true;
        }
        if (this.tankDirty && this.field_145850_b.func_82737_E() % 10L == 0L) {
            Fluid held;
            PacketHandler.sendToAllAround(new PacketTank(this), this);
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            Fluid fluid = held = this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid();
            if (this.lastFluid != held) {
                this.lastFluid = held;
                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.tankDirty = false;
        }
        return res;
    }

    public int getComparatorOutput() {
        FluidTankInfo info = this.getTankInfo(null)[0];
        return info == null || info.fluid == null ? 0 : (int)((double)info.fluid.amount / (double)info.capacity * 15.0);
    }

    private boolean processItems(boolean redstoneCheckPassed) {
        if (!redstoneCheckPassed) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return false;
        }
        return this.drainFullContainer() || this.fillEmptyContainer();
    }

    private boolean fillEmptyContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryFillContainer(this.inventory[1], this.getOutputTanks()[0].getFluid());
        if (fill.result.fluidStack == null) {
            return false;
        }
        if (this.inventory[3] != null) {
            if (this.inventory[3].func_77985_e() && ItemUtil.areStackMergable(this.inventory[3], fill.result.itemStack) && this.inventory[3].field_77994_a < this.inventory[3].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[3].field_77994_a;
            } else {
                return false;
            }
        }
        this.getOutputTanks()[0].setFluid(fill.remainder.fluidStack);
        this.func_70299_a(1, fill.remainder.itemStack);
        this.func_70299_a(3, fill.result.itemStack);
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    private boolean drainFullContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer(this.inventory[0], this);
        if (fill.result.fluidStack == null) {
            return false;
        }
        if (this.inventory[2] != null) {
            if (this.inventory[2].func_77985_e() && ItemUtil.areStackMergable(this.inventory[2], fill.result.itemStack) && this.inventory[2].field_77994_a < this.inventory[2].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[2].field_77994_a;
            } else {
                return false;
            }
        }
        this.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        this.func_70299_a(0, fill.remainder.itemStack);
        this.func_70299_a(2, fill.result.itemStack);
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.func_74768_a("tankType", this.func_145832_p());
        if (this.tank.getFluidAmount() > 0) {
            NBTTagCompound fluidRoot = new NBTTagCompound();
            this.tank.getFluid().writeToNBT(fluidRoot);
            nbtRoot.func_74782_a("tankContents", (NBTBase)fluidRoot);
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        int tankType = nbtRoot.func_74762_e("tankType");
        tankType = MathHelper.func_76125_a((int)tankType, (int)0, (int)1);
        this.tank = tankType == 1 ? new FluidTankEio(32000) : new FluidTankEio(16000);
        if (nbtRoot.func_74764_b("tankContents")) {
            FluidStack fl = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)nbtRoot.func_74781_a("tankContents")));
            this.tank.setFluid(fl);
        } else {
            this.tank.setFluid(null);
        }
    }

    @Override
    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.tank;
    }

    @Override
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public void setTanksDirty() {
        this.tankDirty = true;
    }
}

