/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.zombie.NutrientTank;
import crazypants.enderio.machine.killera.PacketNutrientLevel;
import crazypants.enderio.machine.killera.PacketSwing;
import crazypants.enderio.machine.wireless.WirelessChargedLocation;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import crazypants.util.FluidUtil;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.util.ITankAccess;
import crazypants.vecmath.Vector3d;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileKillerJoe
extends AbstractMachineEntity
implements IFluidHandler,
IEntitySelector,
IHaveExperience,
ITankAccess {
    private static final int IO_MB_TICK = 250;
    protected AxisAlignedBB killBounds;
    private int[] frontFaceAndSides;
    protected AxisAlignedBB hooverBounds;
    protected FakePlayer attackera;
    protected WirelessChargedLocation chargedLocation;
    final NutrientTank fuelTank = new NutrientTank(2000);
    int lastFluidLevelUpdate;
    private boolean tanksDirty;
    private boolean isSwingInProgress;
    private int swingProgressInt;
    private float swingProgress;
    private float prevSwingProgress;
    private final ExperienceContainer xpCon = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.killerJoeMaxXpLevel));
    private boolean hadSword;
    private static final int[] slots = new int[1];
    private static final double[][] faceMidPoints = new double[][]{{0.5, 0.0, 0.5}, {0.5, 1.0, 0.5}, {0.5, 0.5, 0.0}, {0.5, 0.5, 1.0}, {0.0, 0.5, 0.5}, {1.0, 0.5, 0.5}};
    private static final UUID uuid = UUID.fromString("3baa66fa-a69a-11e4-89d3-123b93f75cba");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(uuid, "[EioKillera]");

    public TileKillerJoe() {
        super(new SlotDefinition(1, 0, 0));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockKillerJoe.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.func_77973_b() instanceof ItemSword;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public void func_145845_h() {
        this.updateArmSwingProgress();
        this.hooverXP();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.getAttackera().func_70071_h_();
            if (this.inventory[0] != null != this.hadSword) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.hadSword = this.inventory[0] != null;
            }
        }
        super.func_145845_h();
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCon;
    }

    @Override
    public int[] func_94128_d(int var1) {
        return slots;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (this.inventory[slot] == null || this.inventory[slot].field_77994_a < itemstack.field_77994_a) {
            return false;
        }
        return itemstack.func_77973_b() == this.inventory[slot].func_77973_b();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (this.field_145850_b.func_82737_E() % 10L != 0L) {
            return false;
        }
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround(new PacketNutrientLevel(this), this);
            this.tanksDirty = false;
        }
        if (this.xpCon.isDirty()) {
            PacketHandler.sendToAllAround(new PacketExperianceContainer(this), this);
            this.xpCon.setDirty(false);
        }
        if (!redstoneCheckPassed) {
            return false;
        }
        if ((float)this.fuelTank.getFluidAmount() < (float)this.fuelTank.getCapacity() * 0.7f) {
            return false;
        }
        if (this.func_70301_a(0) == null) {
            return false;
        }
        List entsInBounds = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.getKillBounds());
        if (!entsInBounds.isEmpty()) {
            for (EntityLivingBase ent : entsInBounds) {
                if (!ent.field_70128_L && ent.field_70725_aQ <= 0 && !ent.func_85032_ar()) {
                    if (ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71075_bZ.field_75102_a || Config.killerJoeMustSee && !this.canJoeSee(ent)) continue;
                    FakePlayer fakee = this.getAttackera();
                    fakee.func_70062_b(0, this.func_70301_a(0));
                    fakee.func_71059_n((Entity)ent);
                    this.useNutrient();
                    this.swingWeapon();
                    if (this.func_70301_a((int)0).field_77994_a <= 0 || fakee.func_71045_bC() == null) {
                        this.func_70299_a(0, null);
                    }
                }
                return false;
            }
        }
        return false;
    }

    private boolean canJoeSee(EntityLivingBase ent) {
        Vec3 entPos = Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + (double)ent.func_70047_e()), (double)ent.field_70161_v);
        for (int facing : this.frontFaceAndSides) {
            if (this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)((double)this.field_145851_c + faceMidPoints[facing][0]), (double)((double)this.field_145848_d + faceMidPoints[facing][1]), (double)((double)this.field_145849_e + faceMidPoints[facing][2])), entPos) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFacing(short facing) {
        super.setFacing(facing);
        this.frontFaceAndSides = new int[]{this.facing, ForgeDirection.ROTATION_MATRIX[0][this.facing], ForgeDirection.ROTATION_MATRIX[1][this.facing]};
    }

    public ExperienceContainer getXpContainer() {
        return this.xpCon;
    }

    private void hooverXP() {
        double maxDist = Config.killerJoeHooverXpLength;
        List xp = this.field_145850_b.func_82733_a(EntityXPOrb.class, this.getHooverBounds(), (IEntitySelector)this);
        for (EntityXPOrb entity : xp) {
            double xDist = (double)this.field_145851_c + 0.5 - entity.field_70165_t;
            double yDist = (double)this.field_145848_d + 0.5 - entity.field_70163_u;
            double zDist = (double)this.field_145849_e + 0.5 - entity.field_70161_v;
            double totalDistance = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
            if (totalDistance < 1.5) {
                this.hooverXP(entity);
                continue;
            }
            double d = 1.0 - Math.max(0.1, totalDistance) / maxDist;
            double speed = 0.01 + d * 0.02;
            entity.field_70159_w += xDist / totalDistance * speed;
            entity.field_70179_y += zDist / totalDistance * speed;
            entity.field_70181_x += yDist / totalDistance * speed;
            if (!(yDist > 0.5)) continue;
            entity.field_70181_x = 0.12;
        }
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!this.field_145850_b.field_72995_K && !entity.field_70128_L) {
            this.xpCon.addExperience(entity.func_70526_d());
            entity.func_70106_y();
        }
    }

    public boolean func_82704_a(Entity arg0) {
        return true;
    }

    void swingWeapon() {
        if (this.func_70301_a(0) == null) {
            return;
        }
        if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwingInProgress = true;
            if (this.field_145850_b instanceof WorldServer) {
                PacketHandler.sendToAllAround(new PacketSwing(this), this);
            }
        }
    }

    float getSwingProgress(float p_70678_1_) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * p_70678_1_;
    }

    private void updateArmSwingProgress() {
        this.prevSwingProgress = this.swingProgress;
        int i = this.getArmSwingAnimationEnd();
        if (this.isSwingInProgress) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= i) {
                this.swingProgressInt = 0;
                this.isSwingInProgress = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / (float)i;
    }

    private int getArmSwingAnimationEnd() {
        return 6;
    }

    FakePlayer getAttackera() {
        if (this.attackera == null) {
            this.attackera = new Attackera();
        }
        return this.attackera;
    }

    WirelessChargedLocation getChargedLocation() {
        if (this.chargedLocation == null) {
            this.chargedLocation = new WirelessChargedLocation(this);
        }
        return this.chargedLocation;
    }

    private AxisAlignedBB getKillBounds() {
        if (this.killBounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += Config.killerJoeAttackHeight;
            min.y -= Config.killerJoeAttackHeight;
            ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
            if (ForgeDirectionOffsets.isPositiveOffset(facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled(facingDir, Config.killerJoeAttackLength));
                min.add(ForgeDirectionOffsets.forDir(facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled(facingDir, Config.killerJoeAttackLength));
                max.add(ForgeDirectionOffsets.forDir(facingDir));
            }
            if (facingDir.offsetX == 0) {
                min.x -= Config.killerJoeAttackWidth;
                max.x += Config.killerJoeAttackWidth;
            } else {
                min.z -= Config.killerJoeAttackWidth;
                max.z += Config.killerJoeAttackWidth;
            }
            this.killBounds = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        }
        return this.killBounds;
    }

    private AxisAlignedBB getHooverBounds() {
        if (this.hooverBounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += Config.killerJoeAttackHeight;
            min.y -= Config.killerJoeAttackHeight;
            ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
            if (ForgeDirectionOffsets.isPositiveOffset(facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled(facingDir, Config.killerJoeHooverXpLength));
                min.add(ForgeDirectionOffsets.forDir(facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled(facingDir, Config.killerJoeHooverXpLength));
                max.add(ForgeDirectionOffsets.forDir(facingDir));
            }
            if (facingDir.offsetX == 0) {
                min.x -= Config.killerJoeHooverXpWidth * 2.0;
                max.x += Config.killerJoeHooverXpWidth * 2.0;
            } else {
                min.z -= Config.killerJoeHooverXpWidth * 2.0;
                max.z += Config.killerJoeHooverXpWidth * 2.0;
            }
            this.hooverBounds = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        }
        return this.hooverBounds;
    }

    private void useNutrient() {
        this.fuelTank.drain(Config.killerJoeNutrientUsePerAttackMb, true);
        this.tanksDirty = true;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        boolean res = super.doPull(dir);
        FluidUtil.doPull(this, dir, 250);
        return res;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        int drained;
        FluidStack canDrain;
        boolean res = super.doPush(dir);
        BlockCoord loc = this.getLocation().getLocation(dir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, loc);
        if (target != null && (canDrain = this.drain(dir, 250, false)) != null && canDrain.amount > 0 && (drained = target.fill(dir.getOpposite(), canDrain, true)) > 0) {
            this.drain(dir, drained, true);
        }
        return res;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int res = this.fuelTank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.getID() == EnderIO.fluidNutrientDistillation.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fuelTank.getInfo()};
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.xpCon.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.xpCon.drain(from, maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.xpCon.canDrain(from, fluid);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        if (nbtRoot.func_74764_b("fuelTank")) {
            NBTTagCompound tankRoot = (NBTTagCompound)nbtRoot.func_74781_a("fuelTank");
            if (tankRoot != null) {
                this.fuelTank.readFromNBT(tankRoot);
            } else {
                this.fuelTank.setFluid(null);
            }
        } else {
            this.fuelTank.setFluid(null);
        }
        this.xpCon.readFromNBT(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        if (this.fuelTank.getFluidAmount() > 0) {
            NBTTagCompound tankRoot = new NBTTagCompound();
            this.fuelTank.writeToNBT(tankRoot);
            nbtRoot.func_74782_a("fuelTank", (NBTBase)tankRoot);
        }
        this.xpCon.writeToNBT(nbtRoot);
    }

    @Override
    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == EnderIO.fluidNutrientDistillation) {
            return this.fuelTank;
        }
        return null;
    }

    @Override
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCon};
    }

    @Override
    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    private class Attackera
    extends FakePlayer {
        ItemStack prevWeapon;

        public Attackera() {
            super(MinecraftServer.func_71276_C().func_71218_a(TileKillerJoe.this.func_145831_w().field_73011_w.field_76574_g), DUMMY_PROFILE);
            this.field_70165_t = (double)TileKillerJoe.this.field_145851_c + 0.5;
            this.field_70163_u = (double)TileKillerJoe.this.field_145848_d + 0.5;
            this.field_70161_v = (double)TileKillerJoe.this.field_145849_e + 0.5;
        }

        public void func_70071_h_() {
            this.func_70062_b(0, TileKillerJoe.this.func_70301_a(0));
            ItemStack prev = this.prevWeapon;
            ItemStack cur = this.func_71045_bC();
            if (!ItemStack.func_77989_b((ItemStack)cur, (ItemStack)prev)) {
                if (prev != null) {
                    this.func_110140_aT().func_111148_a(prev.func_111283_C());
                }
                if (cur != null) {
                    this.func_110140_aT().func_111147_b(cur.func_111283_C());
                }
                this.prevWeapon = cur == null ? null : cur.func_77946_l();
            }
            TileKillerJoe.this.getChargedLocation().chargeItems(this.field_71071_by.field_70462_a);
        }
    }
}

