/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ClientChannelRegister;
import crazypants.enderio.machine.hypercube.HyperCubeRegister;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;

public class PacketAddRemoveChannel
implements IMessage,
IMessageHandler<PacketAddRemoveChannel, IMessage> {
    private boolean isAdd;
    private Channel channel;

    public PacketAddRemoveChannel() {
    }

    public PacketAddRemoveChannel(boolean isAdd, Channel channel) {
        this.isAdd = isAdd;
        this.channel = channel;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isAdd);
        buf.writeBoolean(this.channel.isPublic());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.channel.name);
        if (!this.channel.isPublic()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.channel.user.toString());
        }
    }

    public void fromBytes(ByteBuf data) {
        this.isAdd = data.readBoolean();
        boolean isPublic = data.readBoolean();
        String name = ByteBufUtils.readUTF8String((ByteBuf)data);
        String user = null;
        if (!isPublic) {
            user = ByteBufUtils.readUTF8String((ByteBuf)data);
        }
        this.channel = new Channel(name, user == null ? null : user);
    }

    public IMessage onMessage(PacketAddRemoveChannel message, MessageContext ctx) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (message.isAdd) {
                HyperCubeRegister.instance.addChannel(message.channel);
            } else {
                HyperCubeRegister.instance.removeChannel(message.channel);
            }
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketAddRemoveChannel(message.isAdd, message.channel));
        } else if (message.isAdd) {
            ClientChannelRegister.instance.channelAdded(message.channel);
        } else {
            ClientChannelRegister.instance.channelRemoved(message.channel);
        }
        return null;
    }
}

